<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] 	= "controller";
$route['404_override'] 			= 'http404';
$route['translate_uri_dashes'] 	= FALSE;

$route["http404"]                                     = "controller/http404";
$route["admin"]                                       = "admin/index";
$route["admin/((([A-Za-z0-9\-_]+)/?){1,5})"]          = "admin/$1";
$route["joomla-import"]                               = "joomla/index";
$route["joomla-import/((([A-Za-z0-9\-_]+)/?){1,5})"]  = "joomla/$1";
$route["ajax"]                                        = "ajax";
$route["ajax/((([A-Za-z0-9\-_]+)/?){1,5})"]           = "ajax/$1";
$route["install"]                                     = "install/index";
$route["install/([A-Za-z0-9\-_]+)"]                   = "install/$1";
$route["update"]                                      = "update/index";
$route["update/([0-9]+\.[0-9]+\.[0-9]+)"]             = "update/auto/$1";
$route["update/([A-Za-z0-9\-_]+)"]                    = "update/$1";
$route["login"]                                       = "login";
$route["login/([A-Za-z0-9\-_]+)"]                     = "login/$1";
$route["mathcaptcha"]                                 = "mathcaptcha";
$route["mathcaptcha/([A-Za-z0-9\-_]+)"]               = "mathcaptcha/$1";
$route["placeholder"]                                 = "placeholder";
$route["placeholder/([A-Za-z0-9\-_]+)"]               = "placeholder/$1";
$route["crawler/((([A-Za-z0-9\-_]+)/?){1,5})"]        = "crawler/$1";
$route["directives/(/?([A-Za-z0-9\-_]+))*"]           = "directives/index/$1";
$route["modulesettings/((([A-Za-z0-9\-_]+)/?){1,5})"] = "directives/modulesettings/$1";
$route["functions/((([A-Za-z0-9\-_]+)/?){1,5})"]      = "functions/$1";
$route["finder"]                                      = "finder/index";
$route["finder/((([A-Za-z0-9\-_]+)/?){1,5})"]         = "finder/$1";
$route["document/cover/([0-9]+)/([0-9]+)/([0-9]+)"]   = "documents/cover/$1/$2/$3";
$route["document/((([A-Za-z0-9\-_]+)/?){1,5})"]       = "documents/index/$1";
$route["download/(((.+)/?){1,5})"]                    = "download/index";
$route["shop/((([A-Za-z0-9\-_]+)/?){1,5})"]           = "shop/$1";
$route["img/setDPR/([0-9])"]                          = "img/setDPR/$1";
$route["img/([0-9]+)/([0-9]+)/(.+)"]                  = "img/thumb/$1/$2/$3";
$route["img/(((.+)/?){1,25})"]                        = "img/index/$1";
$route['api']                                         = 'api_browser/index';
$route['api/(.*)']                                    = 'api/$1';
$route['api/(.*)/(.*)']                               = 'api/$1/$2';
$route['api/(.*)/(.*)/(.*)']                          = 'api/$1/$2/$3';

require_once(APPLICATION_PATH . "/config/routes_custom.php");

// This allows our dynamic page URLs to work properly.
// Everything that hasn't yet been routed goes to controller/index
$route["(.*)"]											= "controller/index/$1";
