<?php
class Directives extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		// Force SSL if the constant is set but the HTTPS server variable is not set or set but false.
		if(defined("FORCE_SSL") && FORCE_SSL && preg_match('/^http:/', current_url()) && !is_cli())
		{
			if(defined("LOGGING")) { error_log(PRODUCT_NAME . ": Redirecting to HTTPS."); }
			redirect(str_replace("http://", "https://", current_url()), 'auto', 301);
		}
	}

	public function index($directive)
	{
		$this->load->view("directives/" . $directive . "/settings");
	}

	public function modulesettings($directive)
	{
		$this->load->view("modules/" . $directive . "/settings");
	}
}
