<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Placeholder extends CI_Controller
{
	public function __construct()
	{
		parent::__construct();

		// Force SSL if the constant is set but the HTTPS server variable is not set or set but false.
		if(defined("FORCE_SSL") && FORCE_SSL && preg_match('/^http:/', current_url()) && !is_cli())
		{
			if(defined("LOGGING")) { error_log(PRODUCT_NAME . ": Redirecting to HTTPS."); }
			redirect(str_replace("http://", "https://", current_url()), 'auto', 301);
		}
	}

	public function index()
	{
		error_reporting(0);

		$this->load->model(array("module", "moduleinstance"));

		$id = $this->input->get("id");

		$module_instance = new ModuleInstance();
		$module_instance->Load($id);

		$module = new Module();
		$module->Load($module_instance->module_id);

		header ("Content-type: image/png",false);

		$text1 		= "\"$module_instance->tag\"";
		$title 		= "Module Placeholder";
		$lines 		= 2;
		$longest 	= 50;

		// Center the texts by padding both sides to $longest characters
		$longest 	= (strlen($text1) > $longest ? strlen($text1) : $longest);
		$title 		= str_pad($title, $longest, " ", STR_PAD_BOTH);
		$text1 		= str_pad($text1, $longest, " ", STR_PAD_BOTH);

		$im			= imagecreate(((80 * $longest) + 20), 125 * $lines) or die("Can not initialize GD Stream");
		$bgcolor	= ImageColorAllocate($im, 97, 173, 226);
		$textcolor	= ImageColorAllocate($im, 33, 33, 33);

		imagettftext($im, 100, 0, 10, 100, $textcolor, ABSOLUTE_PATH . "/inc/courbd.ttf", $title);
		imagettftext($im, 100, 0, 10, 210, $textcolor, ABSOLUTE_PATH . "/inc/courbd.ttf", $text1);
		imagepng($im, null, 9, PNG_NO_FILTER); 		// output to browser
		imagedestroy($im); 	// Frees Memory
	}
}
?>
