<?php
abstract class Shop_Abstract_Payment_Gateway
{
	/**
	 * Process an order's payment.
	 * @param  Shop_Order $order        Shop_Order object.
	 * @param  Array $payment_vars Array of payment variables from the shopping cart.
	 * @param  Array $messages     Array passed by reference for the gateway to add messages to as necessary.
	 * @return mixed               Returns a transaction ID if successful, otherwise false.
	 */
	public abstract function process($order, $payment_vars, &$messages);

	/**
	 * Does a preliminary check to see if the order qualifies for this gateway to be displayed.
	 * @return boolean True if the gateway should be available, false otherwise.
	 */
	public abstract function qualifies($gateway_data);
}
