<?php
class Directory_Company extends MY_Model
{
	const DB_TABLE = 'directory_companies';
    const DB_TABLE_PK = 'company_id';

    public function __construct()
	{
		parent::__construct();

		$this->province 	= "ON";
		$this->sv_heading 	= 0;
		$this->sv_pitch 	= 0;
		$this->sv_zoom 		= 0;
		$this->published 	= 1;
	}

    function LoadBySiteID($site_id, $limit=100000, $random=false, $sort="c.company")
    {
        $query = $this->db->query("SELECT c.* FROM directory_companies AS c
                                    WHERE c.published='1' AND c.site_id=? " .
                                    ($random ? " ORDER BY RAND() " : " ORDER BY $sort ") . "
                                    LIMIT $limit",
                                    array($site_id));

        return $query->result();
    }

    function LoadByCategoryID($id, $site_id, $sort="c.company")
    {
        $sql = "SELECT c.* FROM directory_companies AS c
                            INNER JOIN directory_companies_categories AS `link` ON c.company_id=`link`.company_id
                            INNER JOIN directory_categories AS cat ON cat.category_id=`link`.category_id
                            WHERE c.published='1' AND c.site_id=?";

        if($id > 0)
        {
            $sql .= " AND cat.category_id='" . $this->db->escape_str($id) . "'";
        }

        $sql .= " ORDER BY $sort";

        $query = $this->db->query($sql, array($site_id));

        return $query->result();
    }

    function LoadByKeyword($q, $site_id, $sort="c.company")
    {
        $q = addslashes(str_replace("'", "", $q));

        $query = $this->db->query("SELECT DISTINCT c.* FROM directory_companies AS c
                            INNER JOIN directory_companies_categories AS `link` ON c.company_id=`link`.company_id
                            INNER JOIN directory_categories AS cat ON cat.category_id=`link`.category_id

                            WHERE c.site_id=? AND
                                c.published='1' AND
                                (REPLACE(c.company, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.contact, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.description, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.address, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.city, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.postalcode, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.phone, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.email, '\'', '') LIKE '%$q%' OR
                                REPLACE(c.website, '\'', '') LIKE '%$q%')
                            ORDER BY $sort",
                            array($site_id));

        return $query->result();
    }

    function loadByURL($site_id, $url)
    {
        $query = $this->db->query("SELECT * FROM directory_companies
                                    WHERE published='1' AND site_id=? AND " . (is_numeric($url) ? "company_id=?" : "url=?"),
                                    array($site_id, $url));

        if($query->num_rows() > 0)
        {
            foreach($query->result() as $row)
            {
                //return the first item
                return $this->Load($row->company_id);
            }
        }
        else
        {
            return false;
        }
    }
}
