<?php
class Document_tag extends MY_Model
{
	const DB_TABLE = 'tag';
    const DB_TABLE_PK = 'tag_id';

    public function get($limit=0, $offset=0)
    {
    	$query = $this->db->query("SELECT * FROM `tag` ORDER BY `tag`");

    	return $query->result();
    }

	public function loadByDocumentID($document_id)
	{
		$query = $this->db->query("SELECT *
    	                          FROM `tag` AS t
    	                          INNER JOIN `tag_document` AS d USING(tag_id)
    	                          WHERE `document_id`=?
    	                          GROUP BY t.tag_id
    	                          ORDER BY t.tag",
    	                          array($document_id));
		return $query->result();
	}

	public function loadByTagName($tag)
	{
		$query = $this->db->query("SELECT *
    	                          FROM `tag` AS t
    	                          WHERE `tag`=?",
    	                          array($tag));

		foreach($query->result() as $row)
		{
			return $this->populate($row);
		}

		return false;
	}

	private function tagID($tag)
	{
		$query = $this->db->query("SELECT * FROM `tag` WHERE `tag`=?", array($tag));

    	if($query->num_rows())
    	{
    		$tag_id = $query->row()->tag_id;
    	}
    	else
    	{
    		$this->db->query("INSERT INTO `tag` SET `tag`=?", array($tag));
    		$tag_id = $this->db->insert_id();
    	}

    	return $tag_id;
	}

	public function add_link($tag, $document_id)
    {
    	$tag = trim($tag);
    	if($tag == "")
    	{
    		return false;
    	}
    	$tag_id = $this->tagID($tag);
    	$result = $this->db->query("SELECT `tag_document_id`
	                               FROM `tag_document`
	                               WHERE `tag_id`=? AND `document_id`=?", array($tag_id, $document_id));

	    if($result->num_rows() > 0)
	    {
		    //a link already exists
		    return true;
	    }
	    else
	    {
	    	$this->db->query("INSERT INTO `tag_document` SET `tag_id`=?, `document_id`=?",
	    	                 array($tag_id, $document_id));

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_link($tag, $document_id)
    {
    	$tag = trim($tag);
    	if($tag == "")
    	{
    		return false;
    	}
    	$tag_id = $this->tagID($tag);
    	$this->db->query("DELETE FROM `tag_document` WHERE `tag_id`=? AND `document_id`=?",
	    	                 array($tag_id, $document_id));

		return ($this->db->affected_rows() > 0);
    }

    public function LoadTokens($q)
    {
    	$sql = "SELECT *
                  FROM `tag`
                  WHERE `tag` LIKE '%" . $this->db->escape_str($q) . "%'
                  ORDER BY `tag`";

    	$query = $this->db->query($sql);

		return $this->tokenize($query->result(), "tag_id", "tag");
    }

    public function deleteAllOtherTags($document_id, $ids)
    {
		$this->db->query("DELETE
		                 FROM `tag_document`
		                 WHERE `document_id`=? AND `tag_id` NOT IN ($ids)", array($document_id));
    }

    public function deleteAllTags($document_id)
    {
		$this->db->query("DELETE
		                 FROM `tag_document`
		                 WHERE `document_id`=?", array($document_id));
    }
}
