<?php
class Event extends MY_Model
{
	const DB_TABLE = 'events';
    const DB_TABLE_PK = 'event_id';

    function LoadWithDetails($id)
    {
        //in this function, we specifically DO NOT override fields when the event is expired - we want its info regardless
        $query = $this->db->query("SELECT e.event_id, e.site_id, e.parent_id, e.event_date, e.time_start, e.time_end, e.all_day,
                                  IF(e.banner_image IS NULL, p.banner_image, e.banner_image) AS banner_image,
                                  IF(e.headline IS NULL, p.headline, e.headline) AS headline,
                                  IF(e.preview IS NULL, p.preview, e.preview) AS preview,
                                  IF(e.description IS NULL, p.description, e.description) AS description,
                                  IF(e.url='', p.url, e.url) AS url,
                                  IF(e.galleries IS NULL, p.galleries, e.galleries) AS galleries,
                                  IF(e.event_date >= CURDATE(), 1, 0) AS upcoming, IF(e.event_date >= CURDATE(), e.event_id, p.event_id) AS link_id
                FROM events AS e
                LEFT JOIN events AS p ON e.parent_id=p.event_id
                WHERE e.event_id=?",
                array($id));

        if($query->num_rows() > 0)
        {
	        $row = $query->result();
	        $row = $row[0];

	        $result = $this->Load($row->event_id);
	        $this->populate($row);  //manually populate so that parent fields will get filled in

	        return $result;
	    }

	    return false;
    }

    function LoadBySiteID($id)
	{
		$query = $this->db->query("SELECT * FROM events WHERE site_id=? ORDER BY `event_date` DESC, time_start", array($id));

		return $query->result();
	}

    function LoadParents($site_id)
	{
		$query = $this->db->query("SELECT * FROM events WHERE site_id=? AND is_parent='1' ORDER BY headline", array($site_id));

		return $query->result();
	}

    function LoadByParentID($id)
    {
        //in this function, we specifically DO NOT override fields when the event is expired - we want its info regardless
        $query = $this->db->query("SELECT e.event_id, e.site_id, e.parent_id, e.event_date, e.time_start, e.time_end, e.all_day,
                                  IF(e.banner_image IS NULL, p.banner_image, e.banner_image) AS banner_image,
                                  IF(e.headline IS NULL, p.headline, e.headline) AS headline,
                                  IF(e.preview IS NULL, p.preview, e.preview) AS preview,
                                  IF(e.description IS NULL, p.description, e.description) AS description,
                                  IF(e.url='', p.url, e.url) AS url,
                                  IF(e.galleries IS NULL, p.galleries, e.galleries) AS galleries,
                                  IF(e.event_date >= CURDATE(), 1, 0) AS upcoming, IF(e.event_date >= CURDATE(), e.event_id, p.event_id) AS link_id
                FROM events AS e
                LEFT JOIN events AS p ON e.parent_id=p.event_id
                WHERE e.parent_id=?
                ORDER BY upcoming DESC, e.event_date ASC, e.time_start ASC",
                array($id));

        return $query->result();
    }

    /**
     * This function loads up an "event stream" consisting of a merged list:
     * - Single events.
     * - ONE child event for upcoming events: The MINIMUM child event date who is upcoming (ie: the NEXT upcoming date of a recurring event).
     * - Parent events where no child is upcoming.
     * @param [type] $site_id [description]
     */
    function LoadEventStream($site_id)
    {
        $query = $this->db->query("SELECT e.event_id, e.site_id, e.parent_id, e.event_date, e.time_start, e.time_end, e.all_day,
                                  IF(e.banner_image IS NULL OR e.event_date < CURDATE(), p.banner_image, e.banner_image) AS banner_image,
                                  IF(e.headline IS NULL OR e.event_date < CURDATE(), p.headline, e.headline) AS headline,
                                  IF(e.preview IS NULL OR e.event_date < CURDATE(), p.preview, e.preview) AS preview,
                                  IF(e.description IS NULL OR e.event_date < CURDATE(), p.description, e.description) AS description,
                                  IF(e.url='' OR e.event_date < CURDATE(), p.url, e.url) AS url,
                                  IF(e.galleries IS NULL OR e.event_date < CURDATE(), p.galleries, e.galleries) AS galleries,
                                  IF(e.event_date >= CURDATE(), 1, 0) AS upcoming, IF(e.event_date >= CURDATE(), e.event_id, p.event_id) AS link_id
                FROM events AS e
                LEFT JOIN events AS p ON e.parent_id=p.event_id
                INNER JOIN (SELECT parent_id, MIN(event_date) AS min_date, MAX(event_date) AS max_date, IF(event_date >= CURDATE(), 1, 0) AS upcoming
                            FROM events
                            GROUP BY parent_id
                            ) AS e2 ON (e2.min_date >= CURDATE() AND e.event_date = e2.min_date) OR (e2.min_date < CURDATE() AND e.event_date = e2.max_date) OR e.parent_id IS NULL
                WHERE e.site_id=? AND (e.parent_id IS NOT NULL OR e.event_date >= CURDATE())
                GROUP BY e.event_id
                ORDER BY upcoming DESC, e.event_date ASC, e.time_start ASC",
                array($site_id));

        return $query->result();
    }

    function loadByURL($site_id, $url)
    {
        $query = $this->db->query("SELECT *, IF(event_date >= CURDATE(), 1, 0) AS upcoming
                                    FROM events
                                    WHERE site_id=? AND (url=? OR event_date=? OR event_id=?)",
                                    array($site_id, $url, $url, $url));

        if($query->num_rows() > 0)
        {
            foreach($query->result() as $row)
            {
                //return the first item
                return $this->LoadWithDetails($row->event_id);
            }
        }
        else
        {
            return false;
        }
    }

	function get($limit=0, $offset=0)
	{
		return $this->LoadBySiteID(Mainframe::active_site_id());
	}

    function search($q)
	{
		if($q == null)
		{
			return array();
		}

		$q = $this->db->escape_str($q);

		$query = $this->db->query("SELECT e.event_id, e.site_id, e.parent_id, e.event_date, e.time_start, e.time_end, e.all_day,
                                  IF(e.banner_image IS NULL, p.banner_image, e.banner_image) AS banner_image,
                                  IF(e.headline IS NULL, p.headline, e.headline) AS headline,
                                  IF(e.preview IS NULL, p.preview, e.preview) AS preview,
                                  IF(e.description IS NULL, p.description, e.description) AS description,
                                  IF(e.url='', p.url, e.url) AS url,
                                  IF(e.galleries IS NULL, p.galleries, e.galleries) AS galleries,
                                  IF(e.event_date >= CURDATE(), 1, 0) AS upcoming, IF(e.event_date >= CURDATE(), e.event_id, p.event_id) AS link_id
                FROM events AS e
                LEFT JOIN events AS p ON e.parent_id=p.event_id
                WHERE e.event_date AND
                	(
               			e.headline LIKE '%$q%' OR
               			e.preview LIKE '%$q%' OR
               			e.description LIKE '%$q%'
                	)
                GROUP BY e.event_id
                ORDER BY e.event_date");

		return $query->result();
	}
}
