<?php
class Page_tag extends MY_Model
{
	const DB_TABLE = 'tag';
    const DB_TABLE_PK = 'tag_id';

    public function get($limit=0, $offset=0)
    {
    	$query = $this->db->query("SELECT * FROM `tag` ORDER BY `tag`");

    	return $query->result();
    }

	public function loadByPageID($page_id)
	{
		$key = "tags:page:" . $page_id;

		if(($query = $this->cache->get($key)) === false)
		{
			$query = $this->db->query("SELECT *
	    	                          FROM `tag` AS t
	    	                          INNER JOIN `tag_page` AS p USING(tag_id)
	    	                          WHERE `page_id`=?
	    	                          GROUP BY t.tag_id
	    	                          ORDER BY t.tag",
	    	                          array($page_id));
			$query = $query->result();
			$this->cache->save($key, $query, 86400);
		}

		return $query;
	}

	public function loadByTagName($tag)
	{
		$query = $this->db->query("SELECT *
    	                          FROM `tag` AS t
    	                          WHERE `tag`=?",
    	                          array($tag));

		foreach($query->result() as $row)
		{
			return $this->populate($row);
		}

		return false;
	}

	private function tagID($tag)
	{
		$query = $this->db->query("SELECT * FROM `tag` WHERE `tag`=?", array($tag));

    	if($query->num_rows())
    	{
    		$tag_id = $query->row()->tag_id;
    	}
    	else
    	{
    		$this->db->query("INSERT INTO `tag` SET `tag`=?", array($tag));
    		$tag_id = $this->db->insert_id();
    	}

    	return $tag_id;
	}

	public function add_link($tag, $page_id)
    {
    	$tag = trim($tag);
    	if($tag == "")
    	{
    		return false;
    	}
    	$tag_id = $this->tagID($tag);
    	$result = $this->db->query("SELECT `tag_page_id`
	                               FROM `tag_page`
	                               WHERE `tag_id`=? AND `page_id`=?", array($tag_id, $page_id));

	    if($result->num_rows() > 0)
	    {
		    //a link already exists
		    return true;
	    }
	    else
	    {
	    	$this->db->query("INSERT INTO `tag_page` SET `tag_id`=?, `page_id`=?",
	    	                 array($tag_id, $page_id));

		    return ($this->db->affected_rows() > 0);
	    }

	    return false;
    }

    public function delete_link($tag, $page_id)
    {
    	$tag = trim($tag);
    	if($tag == "")
    	{
    		return false;
    	}
    	$tag_id = $this->tagID($tag);
    	$this->db->query("DELETE FROM `tag_page` WHERE `tag_id`=? AND `page_id`=?",
	    	                 array($tag_id, $page_id));

		return ($this->db->affected_rows() > 0);
    }

    public function LoadTokens($q)
    {
    	$sql = "SELECT *
                  FROM `tag`
                  WHERE `tag` LIKE '%" . $this->db->escape_str($q) . "%'
                  ORDER BY `tag`";

    	$query = $this->db->query($sql);

		return $this->tokenize($query->result(), "tag_id", "tag");
    }

    public function deleteAllOtherTags($page_id, $ids)
    {
		$this->db->query("DELETE
		                 FROM `tag_page`
		                 WHERE `page_id`=? AND `tag_id` NOT IN ($ids)", array($page_id));
    }

    public function deleteAllTags($page_id)
    {
		$this->db->query("DELETE
		                 FROM `tag_page`
		                 WHERE `page_id`=?", array($page_id));
    }
}
