<?php
class Redirect extends MY_Model
{
	const DB_TABLE = 'redirects';
    const DB_TABLE_PK = 'redirect_id';

    public function loadByURL($url, $site_id)
    {
    	$key = "redirect:" . str_replace("/", "~", $url) . ":" . $site_id;

    	if(($query = $this->cache->get($key)) === false)
    	{
    		$sql = "SELECT r.redirect_id, r.site_id, r.old_url, IF(p.page_id IS NULL, r.new_url, p.url) AS new_url, r.page_id
	    			FROM redirects AS r
	    			LEFT JOIN pages AS p USING(page_id)
	    			WHERE r.site_id=?
	    			AND r.old_url=?
	    			LIMIT 1";

	    	$query = $this->db->query($sql, array($site_id, $url));

	    	foreach($query->result() as $row)
	    	{
	    		$this->cache->save($key, $row, 86400);
	    		return $this->populate($row);
	    	}

	    	$this->cache->save($key, null, 86400);
	    	return false;
	    }

    	return $this->populate($query);
    }

    public function save()
    {
    	$this->load->model("page");

    	// Remove any other redirects that refer to these URLs to avoid reciprocal redirects.
    	if($this->new_url)
    	{
    		$this->db->query("DELETE FROM `redirects` WHERE `site_id`=? AND (`old_url`=? OR `new_url`=? OR `old_url`=? OR `new_url`=?)",
    		                 array(($this->old_url ? $this->old_url : "!"), ($this->old_url ? $this->old_url : "!"), ($this->new_url ? $this->new_url : "!"), ($this->new_url ? $this->new_url : "!")));
    	}
    	else
    	{
    		$this->db->query("DELETE FROM `redirects` WHERE `site_id`=? AND (`old_url`=? OR `new_url`=?)",
    		                 array(($this->old_url ? $this->old_url : "!"), ($this->old_url ? $this->old_url : "!")));
    	}

    	// Prevent creating a redirect from an "old URL" to a "new URL" which is null,
    	// but with a page ID having a URL the same as "old URL."
    	if($this->page_id)
    	{
    		$p = new Page();
    		$p->load($this->page_id);

    		if($p->url == $this->old_url)
	    	{
	    		// Prevent saving the new record, as it would create a cyclical redirect.
	    		return true;
	    	}
    	}

    	return parent::save();
    }
}
