<?php
class Site extends MY_Model
{
	const DB_TABLE = 'sites';
    const DB_TABLE_PK = 'site_id';

    public $pages = array();

    public function load($id)
    {
    	$success = parent::load($id);

    	if($this->shop)
    	{
    		$this->load->model(array("page", "shop/shop_currency"));

    		if($this->currency_id)
    		{
	    		$currency = new Shop_currency();
	    		$currency->load($this->currency_id);
	    		$this->currency_code = $currency->currency_code;
	    	}

	    	if($this->cart_page_id)
    		{
	    		$page = new Page();
	    		$page->load($this->cart_page_id);
	    		$this->cart_url = "/" . $page->url;
	    	}

	    	if($this->checkout_page_id)
    		{
	    		$page = new Page();
	    		$page->load($this->checkout_page_id);
	    		$this->checkout_url = "/" . $page->url;
	    	}
    	}

    	return $success;
    }
}
