<?php
class Paypal_Hosted extends Shop_Abstract_Payment_Gateway
{
	private $config = array();

	public function init()
	{
		$CI =& get_instance();
		$query = $CI->db->query("SELECT * FROM shop_payment_gateways WHERE filename='paypal_hosted' LIMIT 1");

		foreach($query->result() as $row)
		{
			$configs = explode("\n", $row->configuration);
			$this->config = array();

			foreach($configs as $config)
			{
				if($config)
				{
					$line = explode("=", $config, 2);
					$this->config[$line[0]] = $line[1];
				}
			}
		}
	}

	public function process($order, $payment_vars, &$messages)
	{
		if($this->config["sandbox"] == 1)
		{
			$url = "https://www.sandbox.paypal.com/cgi-bin/webscr";
		}
		else
		{
			$url = "https://www.paypal.com/cgi-bin/webscr";
		}

		$cart_items = unserialize($order->products);

		$buynow = '<form method="post" action="' . $url . '" id="paypal_hosted">';
		$buynow .= '
			<input type="hidden" name="cmd" value="_cart">
			<input type="hidden" name="upload" value="1">
			<input type="hidden" name="business" id="business" value="' . $this->config["business"] . '" />
			<input type="hidden" name="notify_url" value="' . $this->config["notify_url"] . '">
			<input type="hidden" name="return" value="' . str_replace("{order_id}", $order->order_id, $this->config["return"]) . '">
			<input type="hidden" name="rm" value="2">
			<input type="hidden" name="cbt" value="Return to ' . COMPANY_NAME . '">
			<input type="hidden" name="cancel_return" value="' . str_replace("{order_id}", $order->order_id, $this->config["cancel_return"]) . '">
			<input type="hidden" name="currency_code" value="' . (class_exists("Shop") ? Shop::currency()->currency_code : "CAD") . '">
			<input type="hidden" name="custom" value="' . $order->order_id . '">';

			$cart_item_count = 0;

			for($cart_item_count = 0; $cart_item_count < count($cart_items); $cart_item_count++)
			{
				$buynow .= '
				<input type="hidden" name="item_name_' . ($cart_item_count + 1) . '" id="item_name_' . ($cart_item_count + 1) . '" value="' . $cart_items[$cart_item_count]->title . ' (x' . $cart_items[$cart_item_count]->quantity . ')">
				<input type="hidden" name="amount_' . ($cart_item_count + 1) . '" id="amount_' . ($cart_item_count + 1) . '" value="' . (number_format($cart_items[$cart_item_count]->price, 2) * $cart_items[$cart_item_count]->quantity) . '">';
			}

			$cart_item_count++;

			$buynow .= '
				<input type="hidden" name="item_name_' . $cart_item_count . '" id="item_name_' . $cart_item_count . '" value="Taxes">
				<input type="hidden" name="amount_' . $cart_item_count . '" id="amount_' . $cart_item_count . '" value="' . $order->tax_total . '">

				<input type="hidden" name="item_name_' . ($cart_item_count + 1) . '" id="item_name_' . ($cart_item_count + 1) . '" value="Shipping">
				<input type="hidden" name="amount_' . ($cart_item_count + 1) . '" id="amount_' . ($cart_item_count + 1) . '" value="' . $order->shipping_total . '">

				<button type="submit" class="btn btn-secondary"><em class="fab fa-2x fa-cc-paypal" aria-hidden="true"></em> Pay With PayPal</button>
			</form>
			<script>
			jQuery(window).on("load", function()
			{
				jQuery("#paypal_hosted button").click();
			});
			</script>';

		$messages[] = "Your order has been submitted but will not be processed until we receive your payment from PayPal.<br><br>" . $buynow;

		return "PayPal";
	}

    public function qualifies($gateway_data)
    {
    	return true;
    }
}
