<?php
class Shop_Cart extends MY_Model
{
    const DB_TABLE = 'shop_cart';
    const DB_TABLE_PK = 'cart_id';

    public function GetItemsBySessionID($session_id)
    {
    	$items = array();
		$query = $this->db->query("SELECT c.*, p.title, p.url, cv.`value` AS price
		                          	FROM shop_cart AS c
		                          	INNER JOIN pages AS p USING(page_id)
		                          	LEFT JOIN content_values AS cv USING(page_id)
                                    WHERE c.session_id=? AND cv.`key`='price'
                                    GROUP BY c.cart_id",
                                    array($session_id));

        foreach($query->result() as $row)
        {
        	$row->product_options = unserialize($row->product_options);

        	if($row->product_options == null)
        	{
        		$row->product_options = array();
        	}

        	$items[] = $row;
        }

        return $items;
    }

    public function EmptyBySessionID($session_id)
    {
		$query = $this->db->query("DELETE FROM shop_cart WHERE session_id=?", array($session_id));
    }
}
