<?php
class Shop_Currency extends MY_Model
{
	const DB_TABLE = 'shop_currency';
    const DB_TABLE_PK = 'currency_id';

	function LoadByCode($code)
	{
		$query = $this->db->query("SELECT * FROM shop_currency WHERE currency_code=?", array($code));

		if($query->num_rows() > 0)
	  	{
	  		$currency_id = false;

	  		foreach($query->result() as $row)
	  		{
	  			//return the first item
	  			$currency_id = $row->currency_id;
		  		break;
	  		}

	  		$query->free_result();
	  		return $this->Load($currency_id);
	  	}
	  	else
	  	{
	  		$query->free_result();
		  	return false;
	  	}
	}

	function LoadAll()
	{
		$query = $this->db->query("SELECT * FROM shop_currency ORDER BY currency_code");

		return $query->result();
	}
}
