<?php
class Shop_Order extends MY_Model
{
	const DB_TABLE = 'shop_orders';
    const DB_TABLE_PK = 'order_id';

    public function __construct()
	{
		parent::__construct();

		$this->site_id 			= 1;
		$this->tax_total 		= 0;
		$this->order_subtotal 	= 0;
		$this->order_total 		= 0;
	}

    /**
     * Add a tracking number to the next available tracking number slot.
     * @param String $tracking_number Tracking number to be added.
     */
    public function add_tracking_number($tracking_number)
    {
        if($this->tracking_number1 == "")
        {
            $this->tracking_number1 = $tracking_number;
        }
        else if($this->tracking_number2 == "")
        {
            $this->tracking_number2 = $tracking_number;
        }
        else if($this->tracking_number3 == "")
        {
            $this->tracking_number3 = $tracking_number;
        }
    }

    function LoadWithDetails($id)
    {
        $query = $this->db->query("SELECT o.*, s.order_status_name, pay.gateway_name AS payment_gateway_name, ship.gateway_name AS shipping_gateway_name
                                  FROM shop_orders AS o
                                  INNER JOIN shop_order_status AS s ON o.order_status_id=s.order_status_id
                                  INNER JOIN shop_payment_gateways AS pay ON o.payment_gateway_id=pay.payment_gateway_id
                                  INNER JOIN shop_shipping_gateways AS ship ON o.shipping_gateway_id=ship.shipping_gateway_id
                                  WHERE o.order_id=?
                                  ORDER BY order_date DESC",
                                  array($id));

        //return the single result
        foreach($query->result() as $result)
        {
            return $this->populate($result);
        }

        return false;
    }

    function LoadByUserID($id)
    {
        $query = $this->db->query("SELECT o.*, s.order_status_name
                                  FROM shop_orders AS o
                                  INNER JOIN shop_order_status AS s ON o.order_status_id=s.order_status_id
                                  WHERE o.user_id=?
                                  ORDER BY order_date DESC",
                                  array($id));

        return $query->result();
    }

    function update_status($order_ids, $status_id)
    {
        $sql = "UPDATE shop_orders SET order_status_id=? WHERE order_id IN ($order_ids)";
        $query = $this->db->query($sql, array($status_id));

        return ($this->db->affected_rows() > 0);
    }

    function get_tracking_urls()
    {
        $CI =& get_instance();
        $CI->load->model(array("shop/shop_shipping_gateway"));
        $CI->load->helper("shipping");

        $gateway = new Shop_Shipping_Gateway();
        $gateway->load($this->shipping_gateway_id);

        if(!$this->shipping_gateway_id)
        {
            return array();
        }

        $CI->load->model("shipping/$gateway->filename");
        $model = $gateway->filename;

        $gateway_name = $CI->$model->name();

        $tracking_urls = array();

        if($this->tracking_number1)
        {
            $tracking_urls[] = $CI->$model->tracking_url($this->tracking_number1);
        }
        if($this->tracking_number2)
        {
            $tracking_urls[] = $CI->$model->tracking_url($this->tracking_number2);
        }
        if($this->tracking_number3)
        {
            $tracking_urls[] = $CI->$model->tracking_url($this->tracking_number3);
        }

        return $tracking_urls;
    }
}
