<?php

class Tag_Button extends Tag
{
	static $default_button_class = array();

	public function __construct($text, $type='button', $attributes=array())
	{
		// Regular Initialization
		parent::__construct('button', $attributes, TAG_CR | TAG_CLOSE);
		$this->attr('type', $type);
		$this->attr('text', $text);

		// Prepend default classes
		foreach(self::$default_button_class as $class)
			$this->attr('class', $class.' '.$this->attr('class'));

		if( !array_key_exists('id',$attributes) )
			$this->attr('id', 'button-'.str_replace(' ', '-', strtolower($this->attr('text'))));
	}

	static function addDefaultClass()
	{
		$args = func_get_args();

		if( count($args) == 0 )
			trigger_error('Variable argument required in addDefaultClass member function.',E_USER_ERROR);

		foreach($args as $arg)
		{
			$arg = trim($arg);
			if( array_search($arg, self::$default_button_class) === false )
				self::$default_button_class[] = $arg;
		}
	}

	static function clearDefaultClass()
	{
		self::$default_button_class = array();
	}
}
