<?php

class Tag_Field_Pure extends Tag_Field
{
	public function render($return=false)
	{
		// Setup the template for the layout of the field and label
		$tmpl = '<div class="pure-control-group">%1$s%2$s</div>'; // Default

		// Special Considerations for labels based on the type of field;
		if( is_object($this->field) && $this->field instanceof Tag )
		{
			switch(get_class($this->field))
			{
				case 'Tag_Textarea':
					$this->label->addClass('textarea');
					break;
			}
		}

		// The structure allows for non-object content such as string values to be shown instead of actual TAG based fields
		if( is_object($this->field) )
		{
			// By default it "should" be a TAG instance

			// Check to see if the required class is needed
			if( $this->field instanceof Tag && $this->label->required )
			{
				$this->field->addClass('required');
				$this->field->attributes["required"] = "required";
			}

			// Render the Tag Object
			$field_markup = $this->field->render(true);
		}
		else
		{
			// Handling of non-object, non-Tag items (literals)
			if( is_null($this->field) || $this->field == '' )
			{
				if( is_null($this->instance_null_string_format) )
				{
					$field_markup = self::$class_null_string_format;
				}
				else
				{
					$field_markup = $this->$instance_null_string_format;
				}
			}
			else
			{
				$field_markup = $this->field;
			}
		}

		if($return)
		{
			return sprintf($tmpl, $this->label->render(true), $field_markup);
		}
		else
		{
			printf($tmpl, $this->label->render(true), $field_markup);
		}
	}
}
