<?php

class Tag_Helper
{
	public static function PureField($label, $field, $required=false)
	{
		$wgt = new Tag_Field_Pure($label, $field, $required);
		$wgt->render();
	}

	public static function Label($text, $for, $attributes=array())
	{
		$wgt = new Tag_Label($text, $for, $attributes);
		$wgt->render();
	}

	public static function Span($text, $attributes=array())
	{
		$wgt = new Tag_Span($text, $attributes);
		$wgt->render();
	}

	public static function Select($name=NULL, $options=NULL, $attributes=array())
	{
		$wgt = new Tag_Select($name, $options, $attributes);
		$wgt->render();
	}

	public static function Text($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Text($name, $attributes);
		$wgt->render();
	}

	public static function Tel($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Tel($name, $attributes);
		$wgt->render();
	}

	public static function Email($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Email($name, $attributes);
		$wgt->render();
	}

	public static function Date($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Date($name, $attributes);
		$wgt->render();
	}

	public static function DateTime($name=NULL, $attributes=array())
	{
		$wgt = new Tag_DateTime($name, $attributes);
		$wgt->render();
	}

	public static function Number($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Number($name, $attributes);
		$wgt->render();
	}

	public static function Password($name=NULL, $attributes=array())
	{
		$wgt = new Tag_Password($name, $attributes);
		$wgt->render();
	}

	public static function Hidden($name=NULL, $value="", $attributes=array())
	{
		$wgt = new Tag_Hidden($name, $value, $attributes);
		$wgt->render();
	}

	public static function Checkbox($name=NULL, $checked=false, $attributes=array())
	{
		$wgt = new Tag_CheckboxSimple($name, $checked, $attributes);
		$wgt->render();
	}

	public static function Radio($name=NULL, $attributes=array())
	{
		$wgt = new Tag_RadioSimple($name, $attributes);
		$wgt->render();
	}

	public static function RadioYesNo($label, $name=NULL, $value="", $attributes=array())
	{
		$yes_args 	= array("id" => $name . "_yes", "value" => "1");
		$no_args 	= array("id" => $name . "_no", "value" => "0");

		if($value == "1")
		{
			$yes_args["checked"] = "checked";
		}
		else if($value == "0")
		{
			$no_args["checked"] = "checked";
		}

		self::Label($label, $name . "_yes");
		self::Radio($name, $yes_args);
		echo(" <label for='" . $name . "_yes' class='inline'>Yes</label>&nbsp;&nbsp;&nbsp;");
		self::Radio($name, $no_args);
		echo(" <label for='" . $name . "_no' class='inline'>No</label>");
	}
}
