<?php

class Tag_Input extends Tag
{
	public function __construct($name=NULL, $attributes=array())
	{
		parent::__construct('input', $attributes);

		if( !is_null($name) )
		{
			$this->attr('name', $name);
			if( !array_key_exists('id', $this->attributes) )
				$this->attr('id', Tag::stripId($name));
		}

		if( is_array($attributes) )
			$this->attributes = array_merge($this->attributes, $attributes);
	}

	public function value($value=NULL)
	{
		$this->attr('value', $value);
	}
}
