<?php

class Tag_Textarea extends Tag
{
	public function __construct($name=NULL, $attributes=array())
	{
		parent::__construct('textarea', $attributes, TAG_CLOSE );
		if( !is_null($name) )
		{
			$this->attr('name', $name);
			if( !array_key_exists('id', $this->attributes) )
				$this->attr('id', Tag::stripId($name));
		}

		// Explicitly set the value if provided in the attributes array
		if( is_array($attributes) && array_key_exists('value',$attributes) )
		{
			$this->value($attributes['value']);
		}
	}

	public function value($value=NULL)
	{
		if( is_null($value) )
			return $value;
		else
			$this->text = $value;
	}

	public function attr($name, $value=NULL)
	{
		if( $name == 'value' )
		{
			if( is_null($value) )
				return $this->text;
			else
				$this->text = $value;
		}
		else
		{
			return parent::attr($name, $value);
		}
	}
}
