<?php
/**
 * This class depends on jQuery and jQuery Tokeninput (http://loopj.com/jquery-tokeninput/).
 */
class Tag_TokenInput extends Tag_Input
{
	private $source = null;
	private $allow_new = false;

	public function __construct($name=NULL, $source="", $allow_new=false, $tokenInput_options=array(), $attributes=array())
	{
		$attributes["class"] = (isset($attributes["class"]) ? $attributes["class"] . " " : "") . "tokeninput form-control";
		$tokenInput_options = array_merge(array("theme" => "facebook", "preventDuplicates" => true), $tokenInput_options);

		parent::__construct($name, $attributes);
		$this->attr('type','text');
		$this->attr("data-source", $source);
		$this->attr("data-allow_new", $allow_new);

		$options = '{';

		$count 		= count($tokenInput_options);
		$counter 	= 0;

		foreach($tokenInput_options as $key=>$value)
		{
			$counter++;
			$options .= "'$key': '$value'" . ($counter < $count ? ", " : "");
		}

		$options .= '}';

		$this->attr("data-options", $options);
	}
}
