<h2>404 Errors List</h2>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_404s",
			"pageLength": 50,
			"order": [[2,'asc'], [1,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "url", "title": "URL Which Causes a 404 Error", "width": "60%", "className": "click", "searchable": true },
		        { "data": "count", "title": "Number of Times Requested", "width": "20%", "className": "click", "searchable": true },
		        { "data": "fixed", "title": "Redirected", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return (data == 1 ? "Yes" : "No");
			        }},
		        { "data": "url", "title": "Create a Redirect", "width": "10%", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/redirect/0?old=' + encodeURIComponent(data) + '&return=/admin/http404s" title="Create Redirect" aria-label="Create Redirect" class="btn btn-sm btn-success"><em class="fas fa-sync" aria-hidden="true"></em></a>';
			        }}
		    ]
		});
	});
</script>
