<h2>Appointment List</h2>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get/appointment",
			"pageLength": 50,
			"order": [[0,'desc'], [1,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "appointment_date", "title": "Date", "width": "15%", "className": "click", "searchable": true },
		        { "data": "name", "title": "Name", "width": "15%", "className": "click", "searchable": true },
		        { "data": "email", "title": "Email", "width": "10%", "className": "click", "searchable": true },
		        { "data": "phone", "title": "Phone", "width": "10%", "className": "click", "searchable": true },
		        { "data": "appointment_for", "title": "For", "width": "20%", "className": "click", "searchable": true },
		        { "data": "notes", "title": "Notes", "width": "20%", "className": "click", "searchable": true },
		        { "data": "booking_appointment_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/appointment_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ]
		});
	});
</script>
