<h2>Crawler Issues</h2>
<p>
Your website has a built in crawler that checks for broken links, images, and other assets.
When it finds issues they will be displayed here.
After you have corrected the issues they will be automatically purged next time the crawler runs.
</p>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get/crawler_issue",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "crawltime", "title": "Crawl Time", "width": "10%", "className": "click", "searchable": true },
		        { "data": "severity", "title": "Severity", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		if(data <= 1)
	                    {
	                    	return "<i class='fas fa-info-circle orange'></i> Warning";
	                    }
	                    else if(data == 2)
	                    {
	                    	return "<i class='fas fa-exclamation-circle red'></i> Important";
	                    }
		        	}},
		        { "data": "page_url", "title": "Page URL Being Checked", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="' + data + '" target="_blank">' + data + '</a>';
		        	}},
		        { "data": "notes", "title": "Notes", "width": "50%", "className": "click", "searchable": true }
		    ]
		});
	});
</script>
