<?php
echo form_open_multipart("admin/directory_category_save", array("id" => "directory_category_form", "class" => "nvForm"));
echo form_hidden("category_id", $category->category_id);
echo form_hidden("parent_id", $category->parent_id);
echo form_hidden("photo", $category->photo);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Directory Category</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/directory_categories" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

<?php
if(count($sites) > 1)
{
	?>
	<div class="<?php echo(FORM_ROW); ?>">
		<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

		<div class="<?php echo(FIELD_COL); ?>">
			<?php
			$wgt = new FeralBasicSelectWidget("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()), "form-control custom-select");

			foreach($sites as $site)
			{
				$wgt->AddOption($site->site_id, $site->name);
			}
			$wgt->Create();
			?>
		</div>
	</div>
	<?php
}
else
{
	echo form_hidden("site_id", ($category->site_id ? $category->site_id : Mainframe::active_site_id()));
}
?>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="category_name" class="<?php echo(LABEL_COL); ?>">Category</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "category_name",
		              "id"          => "category_name",
		              "value"       => $category->category_name,
		              "placeholder" => 'Category Name',
		              "required"	=> "required",
		              "onblur"		=> "updateURL(this, 'url', null, " . ($category->category_id ? 'false' : 'true') . ");",
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "url",
		              "id"          => "url",
		              "value"       => $category->url,
		              "required"	=> "required",
		              "pattern"		=> "[A-Za-z0-9/\-_]*",
					  "placeholder" => "The URL will display in the address bar of the user's web browser.",
					  "title" 		=> "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.",
					  "onkeyup"		=> "jQuery('#url_preview').html(this.value)",
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label class="<?php echo(LABEL_COL); ?>"></label>
	<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><?php echo(LIVE_SITE); ?>/{directory page URL}/<span id="url_preview"><?php echo($category->url); ?></span></div></div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="photo_upload" class="<?php echo(LABEL_COL); ?>">Photo</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<input type="file" name="photo_upload" id="photo_upload" />
		<?php
		if($category->photo)
		{
			?><img src="/images/directory/categories/<?php echo($category->photo); ?>" /><?php
		}
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="description" class="col-12">Description</label>

	<div class="col-12">
		<?php
		echo form_textarea(array(
		              "name"        => "description",
		              "id"          => "description",
		              "value"       => $category->description,
					  "class" 		=> "form-control")
		            );
		?>
	</div>
</div>
<?php
echo form_close();
full_wysiwyg("description");
