<?php
echo form_open_multipart("admin/directory_company_save", array("id" => "directory_company_form", "class" => "nvForm"));
echo form_hidden("company_id", $company->company_id);
echo form_hidden("logo", $company->logo);
echo form_hidden("photo", $company->photo);
echo form_hidden("added", $company->added);
csrf();
?>

<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Company</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/directory_companies" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

	<div class="row">
		<div class="col-12 col-md-6 col-lg-5">
			<?php
			if(count($sites) > 1)
			{
				?>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("site_id", ($company->site_id ? $company->site_id : Mainframe::active_site_id()));

						foreach($sites as $site)
						{
							$wgt->AddOption($site->site_id, $site->name);
						}
						$wgt->Create();
						?>
					</div>
				</div>
				<?php
			}
			else
			{
				echo form_hidden("site_id", ($company->site_id ? $company->site_id : Mainframe::active_site_id()));
			}
			?>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="company" class="<?php echo(LABEL_COL); ?>">Company Name</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "company",
					              "id"          => "company",
					              "value"       => $company->company,
					              "placeholder" => 'Company Name',
					              "required"	=> "required",
								  "onblur"		=> "updateURL(this, 'url', null, " . ($company->company_id ? 'false' : 'true') . ");",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "url",
					              "id"          => "url",
					              "value"       => $company->url,
					              "required"	=> "required",
					              "pattern"		=> "[A-Za-z0-9/\-_]*",
								  "placeholder" => "The URL will display in the address bar of the user's web browser.",
								  "title" 		=> "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.",
								  "onkeyup"		=> "jQuery('#url_preview').html(this.value)",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label class="<?php echo(LABEL_COL); ?>"></label>
				<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><?php echo(LIVE_SITE); ?>/{directory page URL}/<span id="url_preview"><?php echo($company->url); ?></span></div></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="contact" class="<?php echo(LABEL_COL); ?>">Contact Name</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "contact",
					              "id"          => "contact",
					              "value"       => $company->contact,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="address" class="<?php echo(LABEL_COL); ?>">Address</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "address",
					              "id"          => "address",
					              "value"       => $company->address,
					              "required"	=> "required",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="city" class="<?php echo(LABEL_COL); ?>">City</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "city",
					              "id"          => "city",
					              "value"       => $company->city,
					              "required"	=> "required",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="province" class="<?php echo(LABEL_COL); ?>">Province</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					FeralProvinceSelectWidget("province", $company->province);
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="postalcode" class="<?php echo(LABEL_COL); ?>">Postal Code</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "postalcode",
					              "id"          => "postalcode",
					              "value"       => $company->postalcode,
					              "required"	=> "required",
					              "pattern"		=> "[ABCEGHJKLMNPRSTVWXYZabceghjklmnprstvwxyz]\d[ABCEGHJKLMNPRSTVWXYZabceghjklmnprstvwxyz]\s?\d[ABCEGHJKLMNPRSTVWXYZabceghjklmnprstvwxyz]\d",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="logo_upload" class="<?php echo(LABEL_COL); ?>">Logo</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<input type="file" name="logo_upload" id="logo_upload" />
					<?php
					if($company->logo)
					{
						?><img src="/images/directory/logos/<?php echo($company->logo); ?>" /><?php
					}
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="logo_remove" class="<?php echo(LABEL_COL); ?>">Remove Logo When Saved</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<input type="checkbox" value="1" name="logo_remove" id="logo_remove" />
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="photo_upload" class="<?php echo(LABEL_COL); ?>">Photo</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<input type="file" name="photo_upload" id="photo_upload" />
					<?php
					if($company->photo)
					{
						?><img src="/images/directory/companies/<?php echo($company->photo); ?>" /><?php
					}
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="photo_remove" class="<?php echo(LABEL_COL); ?>">Remove Photo When Saved</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<input type="checkbox" value="1" name="photo_remove" id="photo_remove" />
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="internal_notes" class="<?php echo(LABEL_COL); ?>">Internal Notes</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_textarea(array(
					              "name"        => "internal_notes",
					              "id"          => "internal_notes",
					              "value"       => $company->internal_notes,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>
		</div>

		<div class="col-12 col-md-6 col-lg-5">
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="phone" class="<?php echo(LABEL_COL); ?>">Phone</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "phone",
					              "id"          => "phone",
					              "value"       => $company->phone,
					              "type"		=> "tel",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="fax" class="<?php echo(LABEL_COL); ?>">Fax</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "fax",
					              "id"          => "fax",
					              "value"       => $company->fax,
					              "type"		=> "tel",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="email" class="<?php echo(LABEL_COL); ?>">Email</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "email",
					              "id"          => "email",
					              "value"       => $company->email,
					              "type"		=> "email",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="website" class="<?php echo(LABEL_COL); ?>">Website</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "website",
					              "id"          => "website",
					              "value"       => $company->website,
					              "type"		=> "url",
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="latitude" class="<?php echo(LABEL_COL); ?>">Latitude</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "latitude",
					              "id"          => "latitude",
					              "value"       => $company->latitude,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="longitude" class="<?php echo(LABEL_COL); ?>">Longitude</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "longitude",
					              "id"          => "longitude",
					              "value"       => $company->longitude,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="sv_heading" class="<?php echo(LABEL_COL); ?>">Street View Heading</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "sv_heading",
					              "id"          => "sv_heading",
					              "value"       => $company->sv_heading,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="sv_pitch" class="<?php echo(LABEL_COL); ?>">Street View Pitch</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "sv_pitch",
					              "id"          => "sv_pitch",
					              "value"       => $company->sv_pitch,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="sv_zoom" class="<?php echo(LABEL_COL); ?>">Street View Zoom</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "sv_zoom",
					              "id"          => "sv_zoom",
					              "value"       => $company->sv_zoom,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="published" class="<?php echo(LABEL_COL); ?>">Published</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					FeralCheckbox("published", $company->published);
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="instagram" class="<?php echo(LABEL_COL); ?>">Instagram</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "instagram",
					              "id"          => "instagram",
					              "value"       => $company->instagram,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="facebook" class="<?php echo(LABEL_COL); ?>">Facebook</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "facebook",
					              "id"          => "facebook",
					              "value"       => $company->facebook,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="twitter" class="<?php echo(LABEL_COL); ?>">Twitter</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "twitter",
					              "id"          => "twitter",
					              "value"       => $company->twitter,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="linkedin" class="<?php echo(LABEL_COL); ?>">LinkedIn</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "linkedin",
					              "id"          => "linkedin",
					              "value"       => $company->linkedin,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="youtube" class="<?php echo(LABEL_COL); ?>">YouTube</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "youtube",
					              "id"          => "youtube",
					              "value"       => $company->youtube,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="contact_fname" class="<?php echo(LABEL_COL); ?>">Submitter First Name</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "contact_fname",
					              "id"          => "contact_fname",
					              "value"       => $company->contact_fname,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="contact_lname" class="<?php echo(LABEL_COL); ?>">Submitter Last Name</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "contact_lname",
					              "id"          => "contact_lname",
					              "value"       => $company->contact_lname,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="contact_phone" class="<?php echo(LABEL_COL); ?>">Submitter Phone</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "contact_phone",
					              "id"          => "contact_phone",
					              "value"       => $company->contact_phone,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="contact_email" class="<?php echo(LABEL_COL); ?>">Submitter Email</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					echo form_input(array(
					              "name"        => "contact_email",
					              "id"          => "contact_email",
					              "value"       => $company->contact_email,
				              	  "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>
		</div>

		<div class="col-12 col-md-6 col-lg-2">
			<?php
			foreach($categories as $category)
			{
				FeralHidden("category_" . $category->category_id . "_current", $category->active);
				FeralCheckbox("category_" . $category->category_id, $category->active);
				echo(" " . $category->category_name . "<br />");
			}
			?>
		</div>

		<div class="col-12">
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="description" class="col-12">Description</label>

				<div class="col-12">
					<?php
					echo form_textarea(array(
					              "name"        => "description",
					              "id"          => "description",
					              "value"       => $company->description,
					              "class" 		=> "form-control"
					            ));
					?>
				</div>
			</div>
		</div>
	</div>
	<?php
	echo form_close();
	full_wysiwyg("description");
	?>
</div>
