<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Directory Companies</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/directory_company/0" class="btn btn-primary"><em class="fas fa-inbox" aria-hidden="true"></em> Add Company</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_directory_companies",
			"pageLength": 50,
			"order": [[2,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "company", "title": "Company", "width": "40%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/directory_company/' + row["company_id"] + '" class="click">' + data + '</a>';
		        	}},
		        { "data": "description", "title": "Description", "width": "40%", "className": "click", "searchable": true },
		        { "data": "published", "title": "Published", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return data == "1" ? "Yes" : "No";
		        	}},
		        { "data": "company_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/directory_company_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/directory_company/{id}");
			}
		});
	});
</script>
