<div class="document-edit">
	<?php
	echo form_open_multipart("admin/document_save", array("id" => "document_form", "class" => "nvForm"));
	csrf();
	?>
	<input type="hidden" name="document_id" id="document_id" value="<?php echo($document->document_id); ?>" />
	<input type="hidden" name="created" id="created" value="<?php echo($document->created); ?>" />

	<div class="row">
		<div class="<?php echo(TOP_LEFT); ?>">
			<h2>Edit Document</h2>
		</div>
		<div class="<?php echo(TOP_RIGHT); ?>">
			<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
			<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
			<a href="/admin/documents" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<fieldset class="accordion accordion-autofocus">
				<legend><em class="fas fa-fw fa-upload" aria-hidden="true"></em> File Information</legend>

				<div>
					<div class="alert alert-info">"Files" are actual files on your computer which you plan to upload.</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="upload_file" class="<?php echo(LABEL_COL); ?>">Upload New File</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "upload_file",
							              "id"          => "upload_file",
							              "type"       	=> "file",
							              "onchange" 	=> "getFileTitle(event)"
							            ));
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>">&nbsp;</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							FeralCheckbox("overwrite", false);
							echo(" " . form_label("Overwrite File", "overwrite_checkbox"));
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="filename" class="<?php echo(LABEL_COL); ?>">Choose Existing File</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralBasicSelectWidget("filename", ($this->input->post("filename") != "" ? $this->input->post("filename") : $document->filename), "form-control custom-select");
							$wgt->AddOption("0", "N/A");

							foreach($files as $f)
							{
								$wgt->AddOption($f->filename);
							}
							$wgt->Create();
							?>
						</div>
					</div>
				</div>
			</fieldset>

			<fieldset class="accordion">
				<legend><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> Document Information</legend>

				<div>
					<div class="alert alert-info">"Documents" are logical representations of files made available for downloading.</div>
					<?php
					if(count($sites) > 1)
					{
						?>
						<div class="<?php echo(FORM_ROW); ?>">
							<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("site_id", ($this->input->post("site_id") != "" ? $this->input->post("site_id") : ($document->site_id ? $document->site_id : Mainframe::active_site_id())), "form-control custom-select");

								foreach($sites as $site)
								{
									$wgt->AddOption($site->site_id, $site->name);
								}
								$wgt->Create();
								?>
							</div>
						</div>
						<?php
					}
					else
					{
						echo form_hidden("site_id", Mainframe::active_site_id());
					}
					?>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="title" class="<?php echo(LABEL_COL); ?>">Title</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "title",
							              "id"          => "title",
							              "value"       => ($this->input->post("title") != "" ? $this->input->post("title") : $document->title),
							              "required"	=> "required",
										  "onblur"		=> "updateURL(this, 'url', null, " . ($document->document_id ? 'false' : 'true') . ");",
					  					  "class" 		=> "form-control"
							            ));
							?><em class="help">Short and meaningful</em>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "url",
							              "id"          => "url",
							              "value"       => ($this->input->post("url") != "" ? $this->input->post("url") : $document->url),
							              "required"	=> "required",
							              "onkeyup" 	=> "jQuery('#url_preview').html(this.value)",
					 					  "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>
					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>"></label>
						<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><a href="<?php echo(LIVE_SITE); ?>/document/<?php echo($document->url); ?>" target="_blank"><?php echo(LIVE_SITE); ?>/document/<span id="url_preview"><?php echo($document->url); ?></span></a></div></div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="category_id" class="<?php echo(LABEL_COL); ?>">Category</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralBasicSelectWidget("category_id", ($this->input->post("category_id") != "" ? $this->input->post("category_id") : $document->category_id), "form-control custom-select");
							$wgt->AddOption(0, "None");

							foreach($categories as $category)
							{
								$wgt->AddOption($category->category_id, $category->name);
							}
							$wgt->Create();
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="tag_ids" class="<?php echo(LABEL_COL); ?>">Tags</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$x = new Tag_TokenInput("tag_ids", "/ajax/get_tokens/document_tag", true);
							$x->render();
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="content_disposition" class="<?php echo(LABEL_COL); ?>">Display</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralBasicSelectWidget("content_disposition", ($this->input->post("content_disposition") != "" ? $this->input->post("content_disposition") : ($document->content_disposition ? $document->content_disposition : "inline")), "form-control custom-select");
							$wgt->AddOption("inline", "Open In Browser");
							$wgt->AddOption("attachment", "Always Download File");
							$wgt->Create();
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>">&nbsp;</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							FeralCheckbox("published", ($document->published || !$document->document_id));
							echo(" " . form_label("Published", "published_checkbox"));
							?>
						</div>
					</div>
				</div>
			</fieldset>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<?php $this->load->view("admin/acl", array("acls" => $acls)); ?>
		</div>

		<div class="col-12">
			<label for="description" class="col-12">Description</label>

			<div class="col-12">
				<?php
				echo form_textarea(array(
				              "name"        => "description",
				              "id"          => "description",
				              "value"       => ($this->input->post("description") != "" ? $this->input->post("description") : $document->description),
					  		  "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>
	</div>
	<?php
	full_wysiwyg("description");
	echo form_close();
	?>
</div>


<script>
jQuery(window).on("load", function()
{
	// We have to wait until we know the tokeninput is initialized.
	var x = setInterval(function()
	{
		if(!document.getElementById("token-input-tag_ids"))
		{
			return;
		}

		obj = jQuery("#tag_ids");
		obj.tokenInput("clear");

		<?php
		foreach($document->tags as $tag)
		{
			?>obj.tokenInput("add", {id: "<?php echo($tag->tag_id); ?>", name: "<?php echo($tag->tag); ?>"});
			<?php
		}
		?>
		clearInterval(x);
	}, 1000);
});
</script>
