<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Documents</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/document/0" class="btn btn-primary"><em class="far fa-file-pdf" aria-hidden="true"></em> Add Document</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_documents",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "title", "title": "Title", "width": "25%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/document/' + row["document_id"] + '" class="click">' + data + '</a>';
		        	}},
		        { "data": "filename", "title": "Filename", "width": "15%", "className": "click", "searchable": true},
		        { "data": "category_name", "title": "Category", "width": "20%", "className": "click", "searchable": true},
		        { "data": "created", "title": "Created", "width": "10%", "className": "click", "searchable": true},
		        { "data": "modified", "title": "Modified", "width": "10%", "className": "click", "searchable": true},
		        { "data": "published", "title": "Published", "width": "10%", "className": "click", "searchable": true, "render":
		    	function(data, x, row)
		    	{
		    		return (data == 1 ? "Yes" : "No");
		    	}},
		        { "data": "document_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This document will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/document_delete?document_id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/document/{id}");
			}
		});
	});
</script>
