<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Domain Names</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/domain/0" class="btn btn-primary"><em class="fas fa-code" aria-hidden="true"></em> Add Domain Name</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_domains",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "domain", "title": "Domain", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/domain/' + row["domain_id"] + '" class="click">' + data + '</a>';
		        	}},
		        { "data": "site_name", "title": "Site", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/site/' + row["site_id"] + '">' + data + '</a>';
		        	}},
		        { "data": "redirect_url", "title": "Redirect URL", "width": "30%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return (data ? '<a href="' + data + '" target="_blank">' + data + '</a>' : "");
		        	}},
		        { "data": "domain_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/domain_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/domain/{id}");
			}
		});
	});
</script>
