<?php
echo form_open_multipart("admin/event_save", array("id" => "event_form", "class" => "nvForm"));
echo form_hidden("event_id", $event->event_id);
echo form_hidden("banner_image", $event->banner_image);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Event</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/events" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<?php
		if(count($sites) > 1)
		{
			?>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("site_id", ($event->site_id ? $event->site_id : Mainframe::active_site_id()), "form-control custom-select");

					foreach($sites as $site)
					{
						$wgt->AddOption($site->site_id, $site->name);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<?php
		}
		else
		{
			echo form_hidden("site_id", ($event->site_id ? $event->site_id : Mainframe::active_site_id()));
		}
		?>

		<div class="<?php echo(FORM_ROW); ?>">
			<label class="<?php echo(LABEL_COL); ?>">&nbsp;</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralCheckboxWidget("is_parent", $event->is_parent);
				$wgt->SetAttribute("onchange", "jQuery('#parent_id').prop('disabled', this.checked);return false;");
				$wgt->Create();
				?>
				<label for="is_parent_checkbox">This is a Parent Event</label>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="parent_id" class="<?php echo(LABEL_COL); ?>">Parent Event</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralBasicSelectWidget("parent_id", $event->parent_id, "form-control custom-select");
				$wgt->AddOption("", "No Parent Event");

				foreach($events as $event_temp)
				{
					$wgt->AddOption($event_temp->event_id, $event_temp->headline);
				}
				$wgt->Create();
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="event_date" class="<?php echo(LABEL_COL); ?>">Date</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "event_date",
				              "id"          => "event_date",
				              "value"       => $event->event_date,
				              "type" 		=> 'date',
				              "required"	=> "required",
					 		  "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label class="<?php echo(LABEL_COL); ?>">&nbsp;</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				$wgt = new FeralCheckboxWidget("all_day", $event->all_day);
				$wgt->SetAttribute("onchange", "jQuery('#time_start').prop('disabled', jQuery('#all_day').prop('checked') == true);jQuery('#time_end').prop('disabled', jQuery('#all_day').prop('checked') == true);return false;");
				$wgt->Create();
				?>
				<label for="all_day_checkbox">All Day Event</label>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="time_start" class="<?php echo(LABEL_COL); ?>">Start Time</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "time_start",
				              "id"          => "time_start",
				              "value"       => date("H:i", strtotime($event->time_start)),
				              "type" 		=> 'time',
					  		  "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="time_end" class="<?php echo(LABEL_COL); ?>">End Time</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "time_end",
				              "id"          => "time_end",
				              "value"       => date("H:i", strtotime($event->time_end)),
				              "type" 		=> 'time',
					  		  "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<div class="alert alert-info">Headline, banner, preview, and description will be populated by their parent event if left blank.</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="headline" class="<?php echo(LABEL_COL); ?>">Headline</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "headline",
				              "id"          => "headline",
				              "value"       => $event->headline,
							  "onblur"		=> "updateURL(this, 'url', null, " . ($event->event_id ? 'false' : 'true') . ");",
					  		  "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_input(array(
				              "name"        => "url",
				              "id"          => "url",
				              "value"       => $event->url,
				              "pattern"		=> "[A-Za-z0-9/\-_]*",
							  "placeholder" => "The URL will display in the address bar of the user's web browser.",
							  "title" 		=> "Please enter a URL using only letters, numbers, dashes, underscores, or forward slashes.  Do not include '.html' in your URL.",
							  "onkeyup"		=> "jQuery('#url_preview').html(this.value)",
					 		 "class" 		=> "form-control"
				            ));
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label class="<?php echo(LABEL_COL); ?>"></label>
			<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><?php echo(LIVE_SITE); ?>/{events page URL}/<span id="url_preview"><?php echo($event->url); ?></span></div></div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="banner_upload" class="<?php echo(LABEL_COL); ?>">Banner</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<input type="file" name="banner_upload" id="banner_upload" />
				<?php
				if($event->banner_image)
				{
					?><img src="/images/event-banners/<?php echo($event->banner_image); ?>" /><?php
				}
				?>
			</div>
		</div>

		<div class="<?php echo(FORM_ROW); ?>">
			<label for="galleries" class="<?php echo(LABEL_COL); ?>">Galleries</label>

			<div class="<?php echo(FIELD_COL); ?>">
				<?php
				echo form_textarea(array(
				              "name"        => "galleries",
				              "id"          => "galleries",
				              "value"       => $event->galleries,
					  		"class" 		=> "form-control"
				              ));
				?>
			</div>
		</div>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="preview" class="col-12">Preview</label>

	<div class="col-12">
		<?php
		echo form_textarea(array(
		              "name"        => "preview",
		              "id"          => "preview",
		              "value"       => $event->preview,
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="description" class="col-12">Description</label>

	<div class="col-12">
		<?php
		echo form_textarea(array(
		              "name"        => "description",
		              "id"          => "description",
		              "value"       => $event->description,
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<?php
echo form_close();
?>

<script>
jQuery(window).on("load", function()
{
	jQuery('#time_start').prop('disabled', jQuery('#all_day').prop("checked") == true);
	jQuery('#time_end').prop('disabled', jQuery('#all_day').prop("checked") == true);

	var nvFinderPath = "<?php echo(LIVE_SITE); ?>/finder";
	var editor = CKEDITOR.replace( 'preview',
	{
		filebrowserBrowseUrl : nvFinderPath,
		filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
		filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
		filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
		filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
		filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
		height: '600px'
	});
	var editor2 = CKEDITOR.replace( 'description',
	{
		filebrowserBrowseUrl : nvFinderPath,
		filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
		filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
		filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
		filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
		filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
		height: '600px'
	});
});
</script>
