<?php
echo form_open("admin/event_form_save", array("id" => "event_form_form", "class" => "nvForm"));
echo form_hidden("form_id", $form->form_id);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Event Form</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/event_forms" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="event_id" class="<?php echo(LABEL_COL); ?>">Event</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		$wgt = new FeralBasicSelectWidget("event_id", $form->event_id, "form-control custom-select");
		$wgt->SetAttribute("required", "required");
		$wgt->AddOption("", "Select Event");

		foreach($events as $event_temp)
		{
			$wgt->AddOption($event_temp->event_id, $event_temp->headline);
		}
		$wgt->Create();
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="title" class="<?php echo(LABEL_COL); ?>">Form Title</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "title",
		              "id"          => "title",
		              "value"       => $form->title,
		              "required"	=> "required",
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="registration_start" class="<?php echo(LABEL_COL); ?>">Registration Starts</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "registration_start",
		              "id"          => "registration_start",
		              "value"       => date("Y-m-d", strtotime($form->registration_start != null ? $form->registration_start : "today")),
		              "type" 		=> 'date',
		              "required"	=> "required",
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="registration_end" class="<?php echo(LABEL_COL); ?>">Registration Deadline</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "registration_end",
		              "id"          => "registration_end",
		              "value"       => date("Y-m-d", strtotime($form->registration_end != null ? $form->registration_end : "+1 month")),
		              "type" 		=> 'date',
		              "required"	=> "required",
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="fee" class="<?php echo(LABEL_COL); ?>">Registration Fee</label>

	<div class="<?php echo(FIELD_COL); ?>">
		<?php
		echo form_input(array(
		              "name"        => "fee",
		              "id"          => "fee",
		              "value"       => $form->fee,
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>

<div class="<?php echo(FORM_ROW); ?>">
	<label for="terms" class="col-12">Rules &amp; Regulations</label>

	<div class="col-12">
		<?php
		echo form_textarea(array(
		              "name"        => "terms",
		              "id"          => "terms",
		              "value"       => $form->terms,
					  "class" 		=> "form-control"
		            ));
		?>
	</div>
</div>
<?php
echo form_close();
full_wysiwyg("terms"); ?>
