<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Event Registration Forms</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/event_form/0" class="btn btn-primary"><em class="far fa-fw fa-calendar-alt" aria-hidden="true"></em> Add Event Form</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_event_forms",
			"pageLength": 50,
			"order": [[2,'desc'], [3,'asc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "title", "title": "Title", "width": "25%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/event_form/' + row["form_id"] + '">' + data + '</a>';
		        	}},
		        { "data": "headline", "title": "Event", "width": "25%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
		        	{
		        		return '<a href="/admin/event/' + row["event_id"] + '" class="click">' + data + '</a>';
		        	}},
		        { "data": "registration_start", "title": "Registration Starts", "width": "15%", "className": "click", "searchable": true },
		        { "data": "registration_end", "title": "Registration Ends", "width": "15%", "className": "click", "searchable": true },
		        { "data": "fee", "title": "Fee", "width": "10%", "className": "click", "searchable": true,
		        	"function": function(data, x, row)
		        	{
		        		return "$" + data;
		        	}},
		        { "data": "form_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/event_form_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/event_form/{id}");
			}
		});
	});
</script>
