<h1>Joomla Import</h1>

<ol>
	<li>Please import the following tables from Joomla:
		<ul>
			<li>`jos_menu_types`</li>
			<li>`jos_menu`</li>
			<li>`jos_categories`</li>
			<li>`jos_content`</li>
			<li>`jos_modules`</li>
			<li>`jos_users`</li>
		</ul>
	</li>
	<li>Upload the entire contents of your old images directory to `/images`.</li>
	<li>After importing data, convert and install your old template if necessary.</li>
	<li>If you want to import DocMan:
		<ul>
			<li>Import `jos_docman_documents`</li>
			<li>Import `jos_docman_categories`</li>
			<li>Upload the entire contents of the DocMan files directory to `/documents`.</li>
		</ul>
	</li>
</ol>
<?php
if($menus == -1)
{
	?><div class="alert alert-danger">Table `jos_menu_types` doesn't exist.</div><?php
}
else
{
	if($menu_items == -1)
	{
		?><div class="alert alert-danger">Table `jos_menu` doesn't exist.</div><?php
	}
	else
	{
		if($categories == -1)
		{
			?><div class="alert alert-danger">Table `jos_categories` doesn't exist.</div><?php
		}
		else
		{
			if($content == -1)
			{
				?><div class="alert alert-danger">Table `jos_content` doesn't exist.</div><?php
			}
			else
			{
				if($modules == -1)
				{
					?><div class="alert alert-danger">Table `jos_modules` doesn't exist.</div><?php
				}
				else
				{
					if($users == -1)
					{
						?><div class="alert alert-danger">Table `jos_users` doesn't exist.</div><?php
					}
					else
					{
						?>
						<div class="alert alert-success text-center">
							Joomla Data Found
							<hr>
							The following items will be imported:
						</div>
						<ul class="fa-ul" style="width: 200px; margin: 0 auto;">
							<li><em class="fas fa-li fa-list" aria-hidden="true"></em> <?php echo(number_format(count($menus, 0)) . " menus"); ?></li>
							<li><em class="fas fa-li fa-link" aria-hidden="true"></em> <?php echo(number_format(count($menu_items, 0)) . " menu items"); ?></li>
							<li><em class="far fa-li fa-list-alt" aria-hidden="true"></em> <?php echo(number_format(count($categories, 0)) . " categories"); ?></li>
							<li><em class="far fa-li fa-file-alt" aria-hidden="true"></em> <?php echo(number_format(count($content, 0)) . " pages"); ?></li>
							<li><em class="fas fa-li fa-cubes" aria-hidden="true"></em> <?php echo(number_format(count($modules, 0)) . " HTML modules"); ?></li>
							<li><em class="fas fa-li fa-users" aria-hidden="true"></em> <?php echo(number_format(count($users, 0)) . " users"); ?></li>
							<?php
							if($docman != -1)
							{
								?><li><em class="far fa-li fa-file-pdf" aria-hidden="true"></em> <?php echo(number_format(count($docman, 0)) . " DocMan documents"); ?></li><?php
							}
							if($docman_categories != -1)
							{
								?><li><em class="far fa-li fa-list-alt" aria-hidden="true"></em> <?php echo(number_format(count($docman_categories, 0)) . " DocMan categories"); ?></li><?php
							}
							?>
						</ul>

						<div class="alert alert-danger">All existing data will be DESTROYED.</div>

						<div class="text-center"><a href="/joomla-import/step2" class="btn btn-primary">GO <em class="fas fa-fw fa-arrow-right" aria-hidden="true"></em></a></div>
						<?php
					}
				}
			}
		}
	}
}
