<nav class="row" role="navigation">
	<div class="col-12 col-md-6 col-lg-3">
		<?php
		if(isset($sites) && count($sites) > 1)
		{
			?>
			<div class="card my-2">
				<div class="card-header">Active Site</div>

				<form name="site_changer" id="site_changer" method="post" class="nvForm">
					<?php
					if(function_exists("csrf"))
					{
						csrf();
					}
					$wgt = new FeralBasicSelectWidget("active_site_id", Mainframe::active_site_id(), "w-100");
					$wgt->SetAttribute("onchange", "document.getElementById('site_changer').submit();");

					foreach($sites as $s)
					{
						$wgt->AddOption($s->site_id, $s->name);
					}
					$wgt->Create();
					?>
				</form>
			</div>
			<?php
		}
		?>
		<div class="card my-2">
			<div class="card-header">Home</div>

			<div class="list-group list-group-flush">
				<a class="list-group-item list-group-item-action" href="<?php echo(LIVE_SITE); ?>" target="_blank"><em class="fas fa-fw fa-lg fa-eye" aria-hidden="true"></em> View My Website</a>
				<a class="list-group-item list-group-item-action" href="https://analytics.google.com/analytics/web" target="_blank"><em class="fab fa-fw fa-lg fa-google" aria-hidden="true"></em> Google Analytics</a>
				<a class="list-group-item list-group-item-action" href="/admin/help"><em class="fas fa-fw fa-lg fa-book" aria-hidden="true"></em> <?php echo(PRODUCT_NAME); ?> User Manual</a>
				<a class="list-group-item list-group-item-action" href="/login/logout"><em class="fas fa-fw fa-lg fa-sign-out-alt" aria-hidden="true"></em> Logout</a>
			</div>
		</div>

		<?php $this->load->view("common/header_custom_menu", array("sites" => $sites, "user" => $user)); ?>
	</div>

	<div class="col-12 col-md-6 col-lg-3">
		<?php
		if($user->has_any(array(ACTION_PAGES, ACTION_CATEGORIES, ACTION_MENUS, ACTION_MODULES, ACTION_MEDIA, ACTION_DOCUMENTS, ACTION_SEO)))
		{
			?>
			<div class="card my-2">
				<div class="card-header">Website Content</div>

				<div class="list-group list-group-flush">
					<?php
					if($user->has(ACTION_PAGES))
					{
						?>
						<a class="list-group-item list-group-item-action" href="/admin/pages"><em class="far fa-fw fa-lg fa-edit" aria-hidden="true"></em> Content Pages</a>
						<a class="list-group-item list-group-item-action" href="/install/pages"><em class="fas fa-fw fa-lg fa-rocket" aria-hidden="true"></em> Preconfigured Pages</a>
						<?php
					}
					if($user->has(ACTION_CATEGORIES))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/categories"><em class="fas fa-fw fa-lg fa-inbox" aria-hidden="true"></em> Content Categories</a><?php
					}
					if($user->has(ACTION_MENUS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/menus"><em class="fas fa-fw fa-lg fa-link" aria-hidden="true"></em> Menu Links</a><?php
					}
					if($user->has(ACTION_MODULES))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/modules"><em class="fas fa-fw fa-lg fa-puzzle-piece" aria-hidden="true"></em> Modules</a><?php
					}
					if($user->has(ACTION_MEDIA))
					{
						?><a class="list-group-item list-group-item-action" href="/finder"><em class="fas fa-fw fa-lg fa-camera" aria-hidden="true"></em> Media Manager</a><?php
					}
						if($user->has(ACTION_DOCUMENTS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/documents"><em class="far fa-fw fa-lg fa-file-pdf" aria-hidden="true"></em> Documents</a><?php
					}
						if($user->has(ACTION_SEO))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/seo"><em class="fas fa-fw fa-lg fa-sitemap" aria-hidden="true"></em> Search Engine Optimization (SEO)</a><?php
					}
					if(file_exists(ABSOLUTE_PATH . "/modules/booking/booking.php") &&
					   $user->has(ACTION_APPOINTMENTS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/appointments"><em class="far fa-fw fa-lg fa-calendar-alt" aria-hidden="true"></em> Appointments</a><?php
					}
					?>
				</div>
			</div>
			<?php
		}

		if($user->has_any(array(ACTION_EVENTS, ACTION_EVENT_FORMS)))
		{
			?>
			<div class="card my-2">
				<div class="card-header">Events</div>

				<div class="list-group list-group-flush">
					<?php
					if($user->has(ACTION_EVENTS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/events"><em class="far fa-fw fa-lg fa-calendar-alt" aria-hidden="true"></em> Events</a><?php
					}
					if($user->has(ACTION_EVENT_FORMS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/event_forms"><em class="far fa-fw fa-lg fa-list-alt" aria-hidden="true"></em> Event Forms</a><?php
					}
					?>
				</div>
			</div>
			<?php
		}
		?>
		</div>

	<div class="col-12 col-md-6 col-lg-3">
		<?php
		if(Mainframe::site()->shop && $user->has_any(array(ACTION_SHOP_ORDERS, ACTION_SHOP_CONFIG)))
		{
			?>
			<div class="card my-2">
				<div class="card-header">Shop</div>

				<div class="list-group list-group-flush">
					<?php
					if($user->has(ACTION_SHOP_ORDERS))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/orders"><em class="far fa-fw fa-lg fa-list-alt" aria-hidden="true"></em> Orders</a><?php
					}
					if($user->has(ACTION_SHOP_CONFIG))
					{
						?>
						<a class="list-group-item list-group-item-action" href="/admin/gateways"><em class="fas fa-fw fa-lg fa-truck" aria-hidden="true"></em> Payments &amp; Shipping</a>
						<a class="list-group-item list-group-item-action" href="/admin/install_postalcodes"><em class="fas fa-fw fa-lg fa-globe" aria-hidden="true"></em> Install Postal Codes</a>
						<?php
					}
					?>
				</div>
			</div>
			<?php
		}

		if($user->has_any(array(ACTION_DIRECTORY_CATEGORIES, ACTION_DIRECTORY_COMPANIES, ACTION_DIRECTORY_EXPORT)))
		{
			?>
			<div class="card my-2">
				<div class="card-header">Directory</div>

				<div class="list-group list-group-flush">
					<?php
					if($user->has(ACTION_DIRECTORY_CATEGORIES))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/directory_categories"><em class="fas fa-fw fa-lg fa-sitemap" aria-hidden="true"></em> List Categories</a><?php
					}
					if($user->has(ACTION_DIRECTORY_COMPANIES))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/directory_companies"><em class="fas fa-fw fa-lg fa-home" aria-hidden="true"></em> List Companies</a><?php
					}
					if($user->has(ACTION_DIRECTORY_EXPORT))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/directory_export" target="_blank"><em class="fas fa-fw fa-lg fa-database" aria-hidden="true"></em> Directory Export</a><?php
					}
					?>
				</div>
			</div>
			<?php
		}
		?>
	</div>

	<div class="col-12 col-md-6 col-lg-3">
		<div class="card my-2">
			<div class="card-header">Administration</div>

			<div class="list-group list-group-flush">
				<a class="list-group-item list-group-item-action" href="/admin/changelog"><em class="fas fa-fw fa-lg fa-list" aria-hidden="true"></em> Change Log</a>
				<a class="list-group-item list-group-item-action" href="/admin/errorlog"><em class="fas fa-fw fa-lg fa-exclamation-triangle" aria-hidden="true"></em> Error Log</a>
				<a class="list-group-item list-group-item-action" href="/admin/clean_cache"><em class="fas fa-fw fa-lg fa-recycle" aria-hidden="true"></em> Clean Cache</a>
				<a class="list-group-item list-group-item-action" href="/admin/maintenance"><em class="fas fa-fw fa-lg fa-wrench" aria-hidden="true"></em> Optimize Database</a>
				<a class="list-group-item list-group-item-action" href="/admin/optimize_images"><em class="far fa-fw fa-lg fa-file-image" aria-hidden="true"></em> Optimize Images</a>
				<?php
				if($user->has(ACTION_UPDATES))
				{
					?><a class="list-group-item list-group-item-action" href="/update"><em class="fas fa-fw fa-lg fa-cloud-download-alt" aria-hidden="true"></em> Check for Updates</a><?php
				}
				if($user->has(ACTION_USERS))
				{
					?><a class="list-group-item list-group-item-action" href="/admin/users"><em class="far fa-fw fa-lg fa-user" aria-hidden="true"></em> Users</a><?php
				}
				if($user->has(ACTION_ROLES))
				{
					?><a class="list-group-item list-group-item-action" href="/admin/roles"><em class="fas fa-fw fa-lg fa-lock" aria-hidden="true"></em> User Roles</a><?php
				}
				if($user->has(ACTION_CONFIG))
				{
					?>
					<a class="list-group-item list-group-item-action" href="/admin/domains"><em class="fas fa-fw fa-lg fa-code" aria-hidden="true"></em> Domain Names</a>
					<a class="list-group-item list-group-item-action" href="/admin/sites"><em class="fas fa-fw fa-lg fa-globe" aria-hidden="true"></em> Sites</a>
					<?php
					if((ENVIRONMENT == "production" && uri_string() == "admin/environment/development") ||
					   (ENVIRONMENT == "development" && uri_string() != "admin/environment/production"))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/environment/production"><em class="far fa-fw fa-lg fa-gem" aria-hidden="true"></em> Switch to Production</a><?php
					}
					else if((ENVIRONMENT == "development" && uri_string() == "admin/environment/production") ||
					        (ENVIRONMENT == "production" && uri_string() != "admin/environment/development"))
					{
						?><a class="list-group-item list-group-item-action" href="/admin/environment/development"><em class="fas fa-fw fa-lg fa-bug" aria-hidden="true"></em> Switch to Development</a><?php
					}
				}
				?>
			</div>
		</div>
	</div>
</nav>