<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Navigation Menus</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/menu/0" class="btn btn-primary"><em class="fas fa-list" aria-hidden="true"></em> Add Menu</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_menus",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "name", "title": "Name", "width": "90%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/menu/' + row["menu_id"] + '" class="click">' + data + '</a>';
			        }},
		        { "data": "menu_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/menu_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/menu/{id}");
			}
		});
	});
</script>
