<?php
echo form_open("admin/menuitem_save", array("id" => "menuitem_form", "class" => "nvForm"));
echo form_hidden("menu_item_id", $item->menu_item_id);
echo form_hidden("sort", $item->sort);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit Menu Item</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/menu/<?php echo(($item->menu_item_id ? $item->menu_id : $menu_id));?>" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Menu Item Information</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="menu_id" class="<?php echo(LABEL_COL); ?>">Menu <sup class="required">*</sup></label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("menu_id", ($item->menu_item_id ? $item->menu_id : $menu_id), "form-control custom-select");

					foreach($menus as $m)
					{
						$wgt->AddOption($m->menu_id, $m->name);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="parent_id" class="<?php echo(LABEL_COL); ?>">Parent Menu Item</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("parent_id", $item->parent_id, "form-control custom-select");
					$wgt->AddOption("", "Top Level");

					foreach($items as $i)
					{
						$wgt->AddOption($i->menu_item_id, $i->title);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="title" class="<?php echo(LABEL_COL); ?>">Text <sup class="required">*</sup></label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralTextWidget("title", $item->title, "form-control");
					$wgt->SetAttribute("required", "required");
					$wgt->SetAttribute("placeholder", "Displayed on navigation menu.");
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="title_tag" class="<?php echo(LABEL_COL); ?>">Title Tag</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralTextWidget("title_tag", $item->title_tag, "form-control");
					$wgt->SetAttribute("placeholder", "Displayed as a hover tooltip.");
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="page_id" class="<?php echo(LABEL_COL); ?>">Page</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("page_id", $item->page_id, "form-control custom-select");
					$wgt->AddOption("", "URL Below");
					$last_cat_id = "";

					foreach($pages as $page)
					{
						if($last_cat_id != $page->category_id)
						{
							$wgt->AddOption("-1", " --- " . ($page->category_name ? $page->category_name : "Uncategorized") . " --- ");
						}
						$wgt->AddOption($page->page_id, $page->title);
						$last_cat_id = $page->category_id;
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="url" class="<?php echo(LABEL_COL); ?>">URL (overrides page)</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php FeralText("url", $item->url, "form-control"); ?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="icon" class="<?php echo(LABEL_COL); ?>">Icon</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("icon", $item->icon, "form-control custom-select");
					$wgt->AddOption("", "No Icon");
					$wgt->SetAttribute("onchange", "document.getElementById('icon-preview').className='fa-fw ' + this.value");

					foreach(get_icons() as $icon)
					{
						$wgt->AddOption($icon);
					}
					$wgt->Create();
					?>
					<em id="icon-preview" class="fa-fw <?php echo($item->icon); ?>"></em>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="target" class="<?php echo(LABEL_COL); ?>">Target</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("target", $item->target, "form-control custom-select");
					$wgt->AddOption("", "Current Window");
					$wgt->AddOption("_blank", "New Window");
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label class="<?php echo(LABEL_COL); ?>">&nbsp;</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php FeralCheckbox("published", ($item->menu_item_id ? $item->published : "1")); ?>
					<label for="published_checkbox">Published</label>
				</div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<?php $this->load->view("admin/acl", array("acls" => $acls, "accordion" => false)); ?>
		<div class="alert alert-info">Restricting access to a menu item <b>does not</b> restrict access to the item it links to.
		This only hides the menu item from certain roles.
		If you want to prevent access to a specific page or document you must set the access control for that page or document.</div>
	</div>
</div>
<?php
echo form_close();
