<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Page Meta Data</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/metadata_pages?add=1" class="btn btn-primary"><em class="fas fa-plus" aria-hidden="true"></em> Add New Entry</a>
	</div>
</div>

<p>This page allows you to update the meta data for each of your pages, as well as the meta data for any given URL that you want such as a specific portfolio or testimonial item.</p>
<p><b>Updating the URL field for a page will also update that page's URL. Pages that are already indexed by search engines should not have their URLs changed.</b></p>

<form class="nvForm">
	<?php csrf(); ?>
	<table class="<?php echo(ADMIN_TABLE); ?>" id="metadata">
		<thead>
			<tr>
				<th>Page</th><th>URL</th><th>Title</th><th>Description</th><th class="action">Action</th>
			</tr>
		</thead>

		<tbody>
			<?php
			$count = 0;
			$heading_shown = false;

			foreach($metadata as $page)
			{
				$count++;

				FeralHidden("metadata_id_" . $count, $page->metadata_id);
				FeralHidden("site_id_" . $count, ($page->site_id ? $page->site_id : Mainframe::site()->site_id));
				?>
				<tr id="metadata_row_<?php echo($count); ?>">
					<td>
						<?php
						FeralHidden("page_id_" . $count, $page->page_id);

						foreach($pages as $p)
						{
							if($p->page_id == $page->page_id)
							{
								echo($p->title);
								break;
							}
						}
						?>
					</td>
					<td>
						<?php
						$wgt = new FeralTextWidget("url_" . $count, $page->url, "form-control");
						$wgt->SetAttribute("onchange", "set_metadata_dirty($count);");
						$wgt->Create();
						?>
					</td>

					<td>
						<?php
						$wgt = new FeralTextWidget("title_" . $count, $page->title, "form-control");
						$wgt->SetAttribute("onchange", "set_metadata_dirty($count);");
						$wgt->Create();
						?>
					</td>

					<td>
						<textarea name="<?php echo("description_" . $count); ?>" id="<?php echo("description_" . $count); ?>" onchange="set_metadata_dirty(<?php echo($count);?>);" class="form-control"><?php echo($page->description);?></textarea>
					</td>
					<td class="action">
						<div class="nowrap">
							<a href="#" title="Save" id="submit_<?php echo($count); ?>" class="btn btn-sm btn-primary" onclick="save_metadata_pages(<?php echo($count); ?>); return false;"><em class="fas fa-fw fa-save" aria-hidden="true"></em></a>
							<a href="#" title="Delete" id="delete_<?php echo($count); ?>" class="btn btn-sm btn-danger" onclick="nerivon_confirm('Are you sure?', 'This item will be deleted.', 'warning', true, function(confirmed) { if(confirmed) { window.location='/admin/metadata_pages_delete/<?php echo($page->metadata_id); ?>'; }}); return false;" <?php echo($page->page_id > 0 || $page->metadata_id == NULL ? "disabled" : ""); ?>><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>
						</div>
					</td>
				</tr>
				<?php
			}
			?>
		</tbody>
	</table>
</form>
