<div ng-controller="ModuleController" ng-init="load_settings(<?php echo($module->module_instance_id ? $module->module_instance_id : 0); ?>, '<?php echo($module->file_name); ?>', $event);" ng-cloak>
	<?php
	echo form_open_multipart("admin/module_save", array("id" => "module_form", "class" => "nvForm"));
	echo form_hidden("module_instance_id", $module->module_instance_id);
	echo form_hidden("module_id", $module_id);
	csrf();

	$type = new Module();
	$type->Load($module_id);
	?>
	<div class="row">
		<div class="<?php echo(TOP_LEFT); ?>">
			<h2>Edit Module: <?php echo($type->name); ?></h2>
		</div>
		<div class="<?php echo(TOP_RIGHT); ?>">
			<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
			<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
			<a href="/admin/modules" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<fieldset>
				<legend>Module Information</legend>

				<div>
					<?php
					if(count($sites) > 1)
					{
						?>
						<div class="<?php echo(FORM_ROW); ?>">
							<label for="site_id" class="<?php echo(LABEL_COL); ?>">Site <sup class="required">*</sup></label>

							<div class="<?php echo(FIELD_COL); ?>">
								<?php
								$wgt = new FeralBasicSelectWidget("site_id", ($module->site_id ? $module->site_id : Mainframe::active_site_id()), "form-control custom-select");

								foreach($sites as $s)
								{
									$wgt->AddOption($s->site_id, $s->name);
								}
								$wgt->Create();
								?>
							</div>
						</div>
						<?php
					}
					else
					{
						echo form_hidden("site_id", ($module->site_id ? $module->site_id : Mainframe::active_site_id()));
					}
					?>
					<div class="<?php echo(FORM_ROW); ?>">
						<label for="tag" class="<?php echo(LABEL_COL); ?>">Tag <sup class="required">*</sup></label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralTextWidget("tag", $module->tag, "form-control");
							$wgt->SetAttribute("required", "required");
							$wgt->SetAttribute("placeholder", "This is for your own reference.");
							$wgt->Create();
							?>
						</div>
					</div>
					<div class="<?php echo(FORM_ROW); ?>" ng-init="position = '<?php echo($module->position); ?>'">
						<label for="position" class="<?php echo(LABEL_COL); ?>">Template Position</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralBasicSelectWidget("position", $module->position, "form-control custom-select");
							$wgt->SetAttribute("onchange", "setModulePagesDisplay()");
							$wgt->AddOption("", "None - Module will be inserted into content item(s) manually.");
							foreach($positions as $position)
							{
								$wgt->AddOption($position);
							}
							$wgt->Create();
							?>
						</div>
					</div>
					<div class="<?php echo(FORM_ROW); ?>">
						<label for="sort" class="<?php echo(LABEL_COL); ?>">Sort Order</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php FeralSortWidget("sort", 0, (count($modules) + 1), $module->sort, "form-control"); ?>
						</div>
					</div>
					<div class="<?php echo(FORM_ROW); ?> always_on_container">
						<label for="always_on_selected" class="<?php echo(LABEL_COL); ?>">Show This Module On</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php multipleChoiceVertical("always_on", $module->always_on, ["0" => "Selected pages only", "3" => "Main page only", "1" => "All existing and new pages", "2" => "All existing and new pages, except main"], "setModulePagesDisplay()"); ?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="published" class="<?php echo(LABEL_COL); ?>">Published</label>
						<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("published", ($module->module_instance_id ? $module->published : "1")); ?></div>
					</div>
				</div>
			</div>
		</fieldset>

		<div class="<?php echo(TWO_COL); ?>">
			<fieldset class="accordion" id="modules_pages_container">
				<legend>Page Selection</legend>

				<div>
					<p><a href="#" onclick="selectAllModules(1); return false;"><em class="far fa-fw fa-check-square" aria-hidden="true"></em> All Pages</a>
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					<a href="#" onclick="selectAllModules(0);" return false;><em class="far fa-fw fa-square" aria-hidden="true"></em> No Pages</a></p>

					<?php
					foreach($pages as $page)
					{
						?>
						<div class="<?php echo(FORM_ROW); ?>">
							<label for="page_<?php echo($page->page_id); ?>" class="<?php echo(LABEL_COL); ?>"><?php echo($page->title); ?></label>
							<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("page_$page->page_id", $page->module_installed, "module-checkbox", "Show", "Hide"); ?></div>
						</div>
						<?php
					}
					?>
				</div>
			</fieldset>

			<?php $this->load->view("admin/acl", array("acls" => $acls)); ?>
		</div>
	</div>

	<?php
	if(file_exists(APPLICATION_PATH . "/views/modules/" . $module->file_name . "/settings.php"))
	{
		?><div id="module-settings"><div class="text-center"><em class="fas fa-pulse fa-spinner fa-5x" aria-hidden="true"></em></div><?php // Form data will be injected later. ?></div><?php
	}

	echo form_close();
	?>

	<script>
	var nvFinderPath = "<?php echo(LIVE_SITE); ?>/finder";

	jQuery(window).on("load", function()
	{
		jQuery(".wysiwyg-basic").each(function()
		{
			var editor = CKEDITOR.replace( jQuery(this).attr("id"),
			{
				filebrowserBrowseUrl : nvFinderPath,
				filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
				filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
				filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
				filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
				filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
				height: '200px',
				toolbar: [
					{ name: 'document', items: [ 'Source', '-', 'RemoveFormat', '-', 'ShowBlocks' ] },
					{ name: 'insert', items: [ 'nvimage', 'nvpage', 'nvdocument', 'nvlink', 'Unlink', 'nvmodule', 'nvfontawesome', 'HorizontalRule' ] },
					{ name: 'links', items: [ 'Link', 'Unlink' ] },
					{ name: 'clipboard', items: [ 'PasteText', 'PasteFromWord', '-', 'Scayt' ] },
					{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline' ] },
					{ name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
					{ name: 'styles', items: [ 'Styles', 'Format', 'FontSize' ] },
					{ name: 'colors', items: [ 'TextColor', 'BGColor' ] }
				]
			});
		});

		jQuery(".wysiwyg").each(function()
		{
			var editor = CKEDITOR.replace( jQuery(this).attr("id"),
			{
				filebrowserBrowseUrl : nvFinderPath,
				filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
				filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
				filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
				filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
				filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
				height: '500px',
				toolbar: [
					{ name: 'document', items: [ 'Source', '-', 'RemoveFormat', '-', 'ShowBlocks' ] },
					{ name: 'insert', items: [ 'nvimage', 'nvpage', 'nvdocument', 'nvlink', 'Unlink', 'nvmodule', 'nvfontawesome', 'Table', 'HorizontalRule' ] },
					{ name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },
					{ name: 'clipboard', items: [ 'PasteText', 'PasteFromWord', '-', 'Scayt' ] },
					{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline' ] },
					{ name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'Blockquote', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
					{ name: 'styles', items: [ 'Styles', 'Format', 'FontSize' ] },
					{ name: 'colors', items: [ 'TextColor', 'BGColor' ] }
				]
			});
		});

		setModulePagesDisplay();
	});
	</script>
</div>
