<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2><?php echo((count($sites) > 1 ? Mainframe::site()->name . ": " : "")); ?>Configured Modules</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<a href="/admin/modules_available" class="btn btn-primary"><em class="fas fa-puzzle-piece" aria-hidden="true"></em> Add Module</a>
	</div>
</div>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get_modules",
			"pageLength": 50,
			"order": [[1,'desc'], [0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "tag", "title": "Name", "width": "70%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/module/' + row["module_id"] + "/" + row["module_instance_id"] + '" class="click">' + row["display_name"] + '</a>';
			        }},
		        { "data": "position", "title": "Position", "width": "10%", "className": "click", "searchable": true},
		        { "data": "published", "title": "Published", "width": "10%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return (data == "1" ? "Yes" : "No");
			        }},
		        { "data": "module_instance_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="#" title="Delete" class="btn btn-sm btn-danger" onclick="warning(\'Are you sure?\', \'This item will be deleted.\', true, function(confirmed) { if(confirmed) { window.location=\'/admin/module_delete?id=' + data + '\'; }}); return false;"><em class="far fa-fw fa-trash-alt" aria-hidden="true"></em></a>';
	                    buttons += '</div>';
						buttons += '<input type="hidden" class="pk" value="' + row["module_id"] + "/" + row["module_instance_id"] + '" />'

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/module/{id}");
			}
		});
	});
</script>
