<h2>Available Modules</h2>
<p>Don't see a module that fits your needs? Custom modules can be created to serve any purpose. Please <a href="https://nerivon.com/contact" target="_blank">contact us</a> for an estimate.</p>

<table id="list" class="<?php echo(ADMIN_TABLE); ?>"></table>

<script>
	jQuery(window).on("load", function()
	{
		jQuery("#list").DataTable(
	    {
			"pagingType": "full_numbers",
			"processing": true,
			"serverSide": false,
			"language": {"processing": '<?php echo(LOADING_DATATABLES); ?>'},
			"ajax": "/ajax/get/module",
			"pageLength": 50,
			"order": [[0,'asc']],
			"stateSave": true,
			"columns": [
		        { "data": "name", "title": "Name", "width": "90%", "className": "click", "searchable": true,
		        	"render": function(data, x, row)
			        {
			        	return '<a href="/admin/module/' + row["module_id"] + '/0" class="click">' + data + '</a>';
			        }},
		        { "data": "module_id", "title": "Actions", "width": "10%", "className": "text-right", "orderable": false, "searchable": false,
		        	"render": function(data, x, row)
			        {
			        	var buttons = '<div class="nowrap">';
	                    buttons += '<a href="/admin/module/' + data + '/0" class="btn btn-sm btn-primary" title="Install This Module"><em class="fas fa-fw fa-puzzle-piece" aria-hidden="true"></em></a>';
	                    buttons += ' <a href="/admin/module_duplicate/' + data + '" class="btn btn-sm btn-secondary" title="Clone This Module"><em class="fas fa-fw fa-copy" aria-hidden="true"></em></a>';
	                    buttons += '</div>';

	                    return buttons;
			        }}
		    ],
			'drawCallback': function()
			{
				table_hover("#list", "/admin/module/{id}/0");
			}
		});
	});
</script>
