<?php
echo form_open("admin/redirect_save", array("id" => "redirect_form", "class" => "nvForm"));
echo form_hidden("site_id", $site_id);
echo form_hidden("redirect_id", $redirect->redirect_id);
echo form_hidden("return", $return);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit URL Redirect</h2>
	</div>
	<div class="<?php echo(TOP_RIGHT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="<?php echo($return); ?>" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Redirect Information</legend>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="old_url" class="<?php echo(LABEL_COL); ?>">Old URL <sup class="required">*</sup></label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralTextWidget("old_url", $redirect->old_url, "form-control");
					$wgt->SetAttribute("required", "required");
					$wgt->SetAttribute("placeholder", "old-page");
					$wgt->Create();
					?>
				</div>
			</div>

			<p>Choose an existing page OR type a custom URL to redirect to.</p>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="page_id" class="<?php echo(LABEL_COL); ?>">Existing Page</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("page_id", $redirect->page_id, "form-control custom-select");
					$wgt->AddOption("", "URL Below");

					foreach($pages as $page)
					{
						$wgt->AddOption($page->page_id, $page->title);
					}
					$wgt->Create();
					?>
				</div>
			</div>
			<div class="<?php echo(FORM_ROW); ?>">
				<label for="new_url" class="<?php echo(LABEL_COL); ?>">Custom URL</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralTextWidget("new_url", $redirect->new_url, "form-control");
					$wgt->SetAttribute("placeholder", "new-page");
					$wgt->Create();
					?>
				</div>
			</div>
		</fieldset>
	</div>
	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Notes</legend>
			<ul>
				<li>"Old URL" should be a relative URL and should not contain a leading slash.</li>
			</ul>
		</fieldset>
	</div>
</div>
<?php
echo form_close();
