<form id="site_form" method="post" action="/admin/site_save" class="nvForm" enctype="multipart/form-data">
	<input type="hidden" name="site_id" value="<?php echo($site->site_id); ?>" />
	<?php csrf(); ?>

	<div class="row">
		<div class="<?php echo(TOP_LEFT); ?>">
			<h2>Edit Site</h2>
		</div>
		<div class="<?php echo(TOP_RIGHT); ?>">
			<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
			<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
			<a href="/admin/sites" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<fieldset>
				<legend>Site Information</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="name" class="<?php echo(LABEL_COL); ?>">Site Name</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="name" id="name" value="<?php echo($site->name); ?>" class="form-control" required /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="title" class="<?php echo(LABEL_COL); ?>">Site Title</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="title" id="title" value="<?php echo($site->title); ?>" class="form-control" required /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="domain_id" class="<?php echo(LABEL_COL); ?>">Primary Domain</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("domain_id", $site->domain_id, "form-control custom-select");
						$wgt->setAttribute("required", "required");

						foreach($domains as $domain)
						{
							$wgt->AddOption($domain->domain_id, $domain->domain);
						}
						$wgt->Create();
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>Special Pages</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="default_page_id" class="<?php echo(LABEL_COL); ?>">Default Page</label>

					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("default_page_id", $site->default_page_id, "form-control custom-select");
						$wgt->setAttribute("required", "required");

						foreach($pages as $page)
						{
							$wgt->AddOption($page->page_id, $page->title);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="login_page_id" class="<?php echo(LABEL_COL); ?>">Login/Not Authorized Page</label>

					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("login_page_id", $site->login_page_id, "form-control custom-select");
						$wgt->AddOption("", "N/A");

						foreach($pages as $page)
						{
							$wgt->AddOption($page->page_id, $page->title);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="registration_page_id" class="<?php echo(LABEL_COL); ?>">Registration Page</label>

					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("registration_page_id", $site->registration_page_id, "form-control custom-select");
						$wgt->AddOption("", "N/A");

						foreach($pages as $page)
						{
							$wgt->AddOption($page->page_id, $page->title);
						}
						$wgt->Create();
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>Features &amp; Compatibility</legend>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="favicon" class="<?php echo(LABEL_COL); ?>">Generate Favicon</label>
					<?php
					echo form_input(array(
					              "type" 		=> "file",
					              "name"        => "favicon",
					              "id"          => "favicon"
					            ));
					?>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="show_landing_checkbox" class="<?php echo(LABEL_COL); ?>">Show Landing Page</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("show_landing", (isset($site->site_id) && $site->site_id > 0 ? $site->show_landing : "0"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="enable_retina_checkbox" class="<?php echo(LABEL_COL); ?>">Enable High DPI Images</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("enable_retina", (isset($site->site_id) && $site->site_id > 0 ? $site->enable_retina : "1"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="enable_vue_checkbox" class="<?php echo(LABEL_COL); ?>">Enable VueJS</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("enable_vue", (isset($site->site_id) && $site->site_id > 0 ? $site->enable_vue : "0"), "custom-control-input"); ?></div>
				</div>
				
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="webp_checkbox" class="<?php echo(LABEL_COL); ?>">Enable Automatic WebP</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("webp", (isset($site->site_id) && $site->site_id > 0 ? $site->webp : "0"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="confirm_links_checkbox" class="<?php echo(LABEL_COL); ?>">Confirm "New Window" Links</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("confirm_links", (isset($site->site_id) && $site->site_id > 0 ? $site->confirm_links : "0"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="facebook_sdk_checkbox" class="<?php echo(LABEL_COL); ?>">Load Facebook JavaScript SDK</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("facebook_sdk", (isset($site->site_id) && $site->site_id > 0 ? $site->facebook_sdk : "0"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="common_less_checkbox" class="<?php echo(LABEL_COL); ?>">Include Common Stylesheet</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("common_less", (isset($site->site_id) && $site->site_id > 0 ? $site->common_less : "1"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="combine_css_checkbox" class="<?php echo(LABEL_COL); ?>">Combine CSS Files</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("combine_css", (isset($site->site_id) && $site->site_id > 0 ? $site->combine_css : "1"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="loading_overlay_checkbox" class="<?php echo(LABEL_COL); ?>">Show Loading Overlay</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("loading_overlay", (isset($site->site_id) && $site->site_id > 0 ? $site->loading_overlay : "1"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="csp_checkbox" class="<?php echo(LABEL_COL); ?>">Content Security Policy</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("csp", (isset($site->site_id) && $site->site_id > 0 ? $site->csp : "1"), "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label class="<?php echo(LABEL_COL); ?>">Font Awesome</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php multipleChoice("fontawesome", $site->fontawesome, ["0" => "None", "1" => "Free", "2" => "Pro"]); ?></div>
				</div>
				<div class="alert alert-info">In order to use Font Awesome Pro you must have a valid license and add <?php echo($_SERVER["SERVER_NAME"]); ?> as a valid domain.</div>
			</fieldset>

			<fieldset>
				<legend>
					<div class="row">
						<div class="col-6">Mail Settings</div>
						<div class="col-6 text-right"><button type="button" class="btn btn-sm btn-success" onclick="test_mail_settings()"><em class="fas fa-fw fa-cogs" aria-hidden="true"></em> Test Mail Settings</button></div>
					</div>
				</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_from" class="<?php echo(LABEL_COL); ?>">From</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_from",
						              "id"          => "mail_from",
						              "value"       => $site->mail_from,
						              "placeholder" => 'Your Company',
						              "required"    => "required",
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_replyto" class="<?php echo(LABEL_COL); ?>">Reply To</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_replyto",
						              "id"          => "mail_replyto",
						              "value"       => $site->mail_replyto,
						              "type" 		=> "email",
						              "placeholder" => 'Your E-mail Address',
						              "required"    => "required",
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_host" class="<?php echo(LABEL_COL); ?>">Server</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_host",
						              "id"          => "mail_host",
						              "value"       => $site->mail_host,
						              "placeholder" => 'localhost',
						              "required"    => "required",
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_port" class="<?php echo(LABEL_COL); ?>">Port</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_port",
						              "id"          => "mail_port",
						              "value"       => $site->mail_port,
						              "type" 		=> "number",
						              "min" 		=> 1,
						              "step" 		=> 1,
						              "placeholder" => '587',
						              "required"    => "required",
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_tls" class="<?php echo(LABEL_COL); ?>">Security</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php multipleChoice("mail_tls", $site->mail_tls, ["tls" => "TLS (recommended)", "ssl" => "SSL (older)"]); ?></div>
				</div>

				<legend>SMTP Authentication</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_username" class="<?php echo(LABEL_COL); ?>">Username</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_username",
						              "id"          => "mail_username",
						              "value"       => $site->mail_username,
						              "placeholder" => 'noreply@yourdomain.com',
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="mail_password" class="<?php echo(LABEL_COL); ?>">Password</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "mail_password",
						              "id"          => "mail_password",
						              "value"       => $site->mail_password,
						              "type" 		=> "password",
						              "placeholder" => 'noreply\'s password',
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>Other Services</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="ga_code" class="<?php echo(LABEL_COL); ?>">Google Analytics ID</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "ga_code",
						              "id"          => "ga_code",
						              "value"       => $site->ga_code,
						              "placeholder" => 'G-##########',
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="recaptcha" class="<?php echo(LABEL_COL); ?>">Enable reCAPTCHA v3</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("recaptcha", $site->recaptcha); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="recaptcha_public_key" class="<?php echo(LABEL_COL); ?>">reCAPTCHA v3 Site Key</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="recaptcha_public_key" id="recaptcha_public_key" value="<?php echo($site->recaptcha_public_key); ?>" class="form-control" /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="recaptcha_private_key" class="<?php echo(LABEL_COL); ?>">reCAPTCHA v3 Secret Key</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="recaptcha_private_key" id="recaptcha_private_key" value="<?php echo($site->recaptcha_private_key); ?>" class="form-control" /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="recaptcha_threshold" class="<?php echo(LABEL_COL); ?>">reCAPTCHA v3 Threshold</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="number" name="recaptcha_threshold" id="recaptcha_threshold" value="<?php echo($site->recaptcha_threshold); ?>" class="form-control" min="0" max="1" /></div>
				</div>
			</fieldset>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<fieldset>
				<legend>Template Options</legend>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="template_id" class="<?php echo(LABEL_COL); ?>">Template</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("template_id", $site->template_id, "form-control custom-select");

						foreach($templates as $template)
						{
							$wgt->AddOption($template->template_id, $template->name);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="theme" class="<?php echo(LABEL_COL); ?>">Theme</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("theme", $site->theme, "form-control custom-select");
						$wgt->SetAttribute("required", "required");

						foreach($themes as $theme)
						{
							$wgt->AddOption($theme);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="font" class="<?php echo(LABEL_COL); ?>">Font Package</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("font", $site->font, "form-control custom-select");
						$wgt->SetAttribute("required", "required");

						foreach($fonts as $font)
						{
							$wgt->AddOption($font);
						}
						$wgt->Create();
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>Colour Overrides</legend>
				<p>You can override the selected theme's default colours by specifying values here.
				Empty values will use colours from the selected theme.
				Any valid CSS colour may be used.</p>

				<div class="<?php echo(FORM_ROW); ?>">
					<label>Company Logo</label>
					<span>Upload your logo and we'll show you the colour codes used.</span>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="logo_image" class="<?php echo(LABEL_COL); ?>">Choose File</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "type"        => "file",
						              "name"        => "logo_image",
						              "id"          => "logo_image"
						            ));
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?> colour-analysis-result">
					<label class="<?php echo(LABEL_COL); ?>"></label>
					<span id="colour-analysis"></span>
				</div>

				<div class="<?php echo(FORM_ROW); ?> colour-analysis-result">
					<label class="<?php echo(LABEL_COL); ?>"></label>
					<span id="colour-analysis-code"></span>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="colour1" class="<?php echo(LABEL_COL); ?>">Primary Colour</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "colour1",
						              "id"          => "colour1",
						              "placeholder" => "Use colour from selected theme.",
						              "value"       => $site->colour1,
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="colour2" class="<?php echo(LABEL_COL); ?>">Secondary Colour</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "colour2",
						              "id"          => "colour2",
						              "placeholder" => "Use colour from selected theme.",
						              "value"       => $site->colour2,
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="colour3" class="<?php echo(LABEL_COL); ?>">Third Colour</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "colour3",
						              "id"          => "colour3",
						              "placeholder" => "Use colour from selected theme.",
						              "value"       => $site->colour3,
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="colour4" class="<?php echo(LABEL_COL); ?>">Fourth Colour</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "colour4",
						              "id"          => "colour4",
						              "placeholder" => "Use colour from selected theme.",
						              "value"       => $site->colour4,
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="colour5" class="<?php echo(LABEL_COL); ?>">Fifth Colour</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_input(array(
						              "name"        => "colour5",
						              "id"          => "colour5",
						              "placeholder" => "Use colour from selected theme.",
						              "value"       => $site->colour5,
						              "class" 		=> "form-control"
						            ));
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>LESS CSS Overrides</legend>
				<p>You can apply small tweaks to the site's styles using LESS CSS. Variables from common.less and other areas are available.</p>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="less_css" class="<?php echo(LABEL_COL); ?>">LESS CSS</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						echo form_textarea(array(
						              "name"  => "less_css",
						              "id"    => "less_css",
						              "value" => $site->less_css,
						              "class" => "form-control"
						            ));
						?>
					</div>
				</div>
			</fieldset>

			<fieldset>
				<legend>Shop Configuration</legend>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="shop_checkbox" class="<?php echo(LABEL_COL); ?>">Include Shop Functions</label>
					<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("shop", $site->shop, "custom-control-input"); ?></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="cart_page_id" class="<?php echo(LABEL_COL); ?>">Shopping Cart Page</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("cart_page_id", $site->cart_page_id, "form-control custom-select");
						$wgt->AddOption("", "N/A");

						foreach($pages as $page)
						{
							$wgt->AddOption($page->page_id, $page->title);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="checkout_page_id" class="<?php echo(LABEL_COL); ?>">Checkout Page</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("checkout_page_id", $site->checkout_page_id, "form-control custom-select");
						$wgt->AddOption("", "N/A");

						foreach($pages as $page)
						{
							$wgt->AddOption($page->page_id, $page->title);
						}
						$wgt->Create();
						?>
					</div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="order_notifications" class="<?php echo(LABEL_COL); ?>">Send Order Notifications To (comma separated)</label>
					<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="order_notifications" id="order_notifications" value="<?php echo($site->order_notifications); ?>" class="form-control" /></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="tax_numbers" class="<?php echo(LABEL_COL); ?>">Tax Numbers</label>
					<div class="<?php echo(FIELD_COL); ?>"><textarea name="tax_numbers" id="tax_numbers" class="form-control"><?php echo($site->tax_numbers); ?></textarea></div>
				</div>

				<div class="<?php echo(FORM_ROW); ?>">
					<label for="currency_id" class="<?php echo(LABEL_COL); ?>">Currency</label>
					<div class="<?php echo(FIELD_COL); ?>">
						<?php
						$wgt = new FeralBasicSelectWidget("currency_id", $site->currency_id, "form-control custom-select");
						$wgt->AddOption("", "N/A");

						foreach($currencies as $currency)
						{
							$wgt->AddOption($currency->currency_id, $currency->currency_name);
						}
						$wgt->Create();
						?>
					</div>
				</div>
			</fieldset>
		</div>
	</div>
</form>

<script>
	var datatable;

	jQuery(window).on("load", function()
	{
		jQuery("#logo_image").change(function()
		{
			var result = jQuery("#colour-analysis");
			result.html('<em class="fas fa-fw fa-spin fa-spinner fa-2x" aria-hidden="true"></em> Analyzing Image...');
			jQuery(".colour-analysis-result").slideDown(500);

			var formData = new FormData();

			try
			{
				formData.append("image", document.getElementById("logo_image").files[0]);
			}
			catch(e){}

			$.ajax(
			{
				url: '/functions/colour_analysis',
				type: 'POST',
				data: formData,
				processData: false,
				contentType: false
			}).done(function(data, textStatus, jqXHR)
			{
				result.siblings("label").eq(0).html("Colour Breakdown");

				colours = data;
				html 	= "";

				for(i=0; i<colours.length; i++)
				{
					colour 	= colours[i];
					// rgb 	= 'rgb(' + colour["red"] + ',' + colour["green"] + ',' + colour["blue"] + ')';
					hex 	= colour["hex"];
					html 	+= '<span class="colour-analysis-preview" style="background: ' + hex + ';" onclick="colour_preview(this, \'' + hex + '\')">' + (i+1) + '</span>';
				}
				result.html(html);
				jQuery(".colour-analysis-preview").eq(0).click();
			}).fail(function(jqXHR, textStatus, errorThrown)
			{
				result.html("An Error Occurred: " + errorThrown);
			});
		});

		colour_preview = function(obj, hex)
		{
			jQuery('#colour-analysis-code').html("Selected Colour Code: " + hex);
			jQuery('.colour-analysis-preview').removeClass('colour-analysis-clicked');
			jQuery(obj).addClass('colour-analysis-clicked');
		}
	});

	function test_mail_settings()
	{
		nerivon_input("Test Mail Settings", "<p>You will receive one or more test messages as the system tries to determine some usable settings. If the settings you've entered don't work some other common configurations will be tried.</p><br><br><p>Enter an email address to receive these test messages.</p>", false, function(email)
		{
			if(!email)
			{
				error("No Email Address", "You must enter your email address to receive the test messages.", true, null);
				return;
			}

			wait("Testing Mail Settings", "This dialog will close automatically.");

			jQuery.ajax(
			{
				url: '/admin/test_mail_settings',
				type: 'POST',
				data:
				{
					mail_to: email,
					mail_from: jQuery("#mail_from").val(),
					mail_replyto: jQuery("#mail_replyto").val(),
					mail_host: jQuery("#mail_host").val(),
					mail_port: jQuery("#mail_port").val(),
					mail_tls: (jQuery("#mail_tls").prop("checked") ? "tls" : "ssl"),
					mail_username: jQuery("#mail_username").val(),
					mail_password: jQuery("#mail_password").val()
				},
				contentType: "application/x-www-form-urlencoded"
			}).done(function(data, textStatus, jqXHR)
			{
				if(data == "")
				{
					success("Correct Mail Settings", "<p>The mail settings you entered appear to be valid.</p>", true, null);
				}
				else
				{
					settings = "Server: " + data.mail_host + "<br>";
					settings += "Port: " + data.mail_port + "<br>";
					settings += "SSL/TLS: " + data.mail_tls.toUpperCase() + "<br>";
					settings += "Username: " + data.mail_username + "<br>";
					settings += "Password: " + data.mail_password;

					nerivon_confirm("Correct Mail Settings Found", "<p>The mail settings you entered did not work.</p><br><br><p>However, the following settings worked:</p><br><br><p>" + settings + "</p><br><br><p>Do you want to use these settings?</p>", "info", true, function(isConfirm)
					{
						if(isConfirm)
						{
							jQuery("#mail_host").val(data.mail_host);
							jQuery("#mail_port").val(data.mail_port);
							jQuery("#mail_username").val(data.mail_username);
							jQuery("#mail_password").val(data.mail_password);

							if(data.mail_tls == "tls")
							{
								jQuery("#mail_tls").prop("checked", true);
							}
							else if(data.mail_tls == "ssl")
							{
								jQuery("#mail_ssl").prop("checked", true);
							}
						}
					});
				}
			}).fail(function(jqXHR, textStatus, errorThrown)
			{
				error("Incorrect Mail Settings", "<p>The mail settings you entered did not work.</p><br><br><p>Additonally, no working variations could be determined.</p>", true, null);
			});
		});
	}
</script>
