<?php
echo form_open("admin/user_save", array("id" => "user_form", "class" => "nvForm"));
echo form_hidden("user_id", $edit_user->user_id);
echo form_hidden("joined", $edit_user->joined);
echo form_hidden("joined_site_id", $edit_user->joined_site_id);
echo form_hidden("last_login", $edit_user->last_login);
csrf();
?>
<div class="row">
	<div class="<?php echo(TOP_LEFT); ?>">
		<h2>Edit User</h2>
	</div>
	<div class="<?php echo(TOP_LEFT); ?>">
		<button type="submit" name="submit_action" id="submit" value="close" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Close</button>
		<button type="submit" name="submit_action" id="submit2" value="continue" class="btn btn-primary"><em class="fas fa-save" aria-hidden="true"></em> Save &amp; Continue</button>
		<a href="/admin/users" class="btn btn-secondary"><em class="fas fa-times" aria-hidden="true"></em> Cancel</a>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>Login Information</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="username" class="<?php echo(LABEL_COL); ?>">Username</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="username" id="username" value="<?php echo($edit_user->username); ?>" required class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="password" class="<?php echo(LABEL_COL); ?>"><?php echo(($edit_user->user_id ? "Change" : "Create")); ?> Password</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="password" name="password" id="password" <?php echo(($edit_user->user_id ? "" : "required")); ?> pattern=".{<?php echo(($edit_user->user_id ? "0" : "8")); ?>,255}" title="Enter a password at least 8 characters long." class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="password2" class="<?php echo(LABEL_COL); ?>">Confirm Password</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="password" name="password2" id="password2" <?php echo(($edit_user->user_id ? "" : "required")); ?> title="Retype your new password." class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="active" class="<?php echo(LABEL_COL); ?>">Active</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php yesNo("active", ($edit_user->user_id ? $edit_user->active : 1)); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label class="<?php echo(LABEL_COL); ?>">Joined</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php echo(($edit_user->joined != "0000-00-00 00:00:00" ? $edit_user->joined : "Unknown")); ?></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label class="<?php echo(LABEL_COL); ?>">Joined From Site</label>
				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$site = new Site();
					$site->Load($edit_user->joined_site_id);
					echo(isset($site->name) ? $site->name : "Unknown");
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label class="<?php echo(LABEL_COL); ?>">Last Login</label>
				<div class="<?php echo(FIELD_COL); ?>"><?php echo(($edit_user->last_login && $edit_user->last_login != "0000-00-00 00:00:00" ? $edit_user->last_login : "Never")); ?></div>
			</div>
		</fieldset>
	</div>

	<div class="<?php echo(TWO_COL); ?>">
		<fieldset>
			<legend>User Information</legend>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="fname" class="<?php echo(LABEL_COL); ?>">First Name</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="fname" id="fname" value="<?php echo($edit_user->fname); ?>" required class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="lname" class="<?php echo(LABEL_COL); ?>">Last Name</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="lname" id="lname" value="<?php echo($edit_user->lname); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="company" class="<?php echo(LABEL_COL); ?>">Company</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="company" id="company" value="<?php echo($edit_user->company); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="email" class="<?php echo(LABEL_COL); ?>">Email Address</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="email" name="email" id="email" value="<?php echo($edit_user->email); ?>" required class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="phone" class="<?php echo(LABEL_COL); ?>">Phone Number</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="tel" name="phone" id="phone" value="<?php echo($edit_user->phone); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shopper_group_id" class="<?php echo(LABEL_COL); ?>">Shopper Group</label>

				<div class="<?php echo(FIELD_COL); ?>">
					<?php
					$wgt = new FeralBasicSelectWidget("shopper_group_id", $edit_user->shopper_group_id, "form-control custom-select");
					$wgt->AddOption("", "N/A");

					foreach($shopper_groups as $shopper_group)
					{
						$wgt->AddOption($shopper_group->shopper_group_id, $shopper_group->group_name);
					}
					$wgt->Create();
					?>
				</div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shipping_address" class="<?php echo(LABEL_COL); ?>">Shipping Address</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_address" id="shipping_address" value="<?php echo($edit_user->shipping_address); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shipping_city" class="<?php echo(LABEL_COL); ?>">Shipping City</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_city" id="shipping_city" value="<?php echo($edit_user->shipping_city); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shipping_postalcode" class="<?php echo(LABEL_COL); ?>">Shipping Postal Code</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_postalcode" id="shipping_postalcode" value="<?php echo($edit_user->shipping_postalcode); ?>" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shipping_province" class="<?php echo(LABEL_COL); ?>">Shipping Province</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_province" id="shipping_province" value="<?php echo(($edit_user->shipping_province ? $edit_user->shipping_province : "ON")); ?>" maxlength="2" class="form-control" /></div>
			</div>

			<div class="<?php echo(FORM_ROW); ?>">
				<label for="shipping_country" class="<?php echo(LABEL_COL); ?>">Shipping Country</label>
				<div class="<?php echo(FIELD_COL); ?>"><input type="text" name="shipping_country" id="shipping_country" value="<?php echo(($edit_user->shipping_country ? $edit_user->shipping_country : "CA")); ?>" maxlength="2" class="form-control" /></div>
			</div>
		</fieldset>
	</div>
</div>

<fieldset>
	<legend>Which Roles Can This User Assume?</legend>

	<?php
	if(isset($roles) && count($roles) > 0)
	{
		?><div class="row"><?php
		$role_count = count($roles) - 1;	// Subtract 1 for the hidden public role.

		if($role_count == 3 || $role_count % 3 == 0)
		{
			$role_class = THREE_COL;
		}
		else if($role_count == 2 || $role_count % 2 == 0)
		{
			$role_class = TWO_COL;
		}
		else if($role_count >= 4)
		{
			$role_class = FOUR_COL;
		}
		else
		{
			$role_class = "col-12";
		}

		foreach($roles as $role)
		{
			// Prevent assigning the "Public" role to users because there's no reason to.
			if($role->acl_role_id == 1)
			{
				continue;
			}
			?><div class="<?php echo($role_class); ?>"><fieldset><legend><?php
			FeralCheckbox("role_" . $role->acl_role_id, $role->active);
			?> <label for='role_<?php echo($role->acl_role_id); ?>_checkbox'><?php echo($role->role); ?></label></legend>
			<?php
			if($role->description)
			{
				?><p class="help m-0 p-0"><?php echo($role->description); ?></p><?php
			}
			?><ul class="fa-ul"><?php

			foreach($role->actions as $action)
			{
				if($action->active)
				{
					?><li><em class="fas fa-li fa-check green" aria-hidden="true"></em> <?php echo($action->action); ?></li><?php
				}
			}
			?></ul></fieldset></div><?php
		}
		?></div><?php
	}
	else
	{
		?><div class="alert alert-danger">No Roles Defined Yet.</div><?php
	}
	?>
</fieldset>

<?php
echo form_close();
