<?php
$this->load->view("modules/shop/header", array("user" => get_user()));

$subtitle   = $page->field("subtitle");
$content    = $page->field("content1");
$main_image = $page->field("main_image");
$image      = $page->field("image" . $main_image);
$alt        = htmlentities($page->title);

if(uri_string() == $page->url)
{
	$youtube = $page->field("youtube");
	$vimeo   = $page->field("vimeo");

	// $youtube = "CDjFBqCY9kk";
	// $youtube = "https://www.youtube-nocookie.com/embed/CDjFBqCY9kk?rel=0";
	// $vimeo   = "6271487";

	// Extract the video ID if necessary.
	// We want $youtube and $vimeo to only ever be a video ID.
	if($youtube)
	{
		if(preg_match('/youtube(-nocookie)?\.com\/embed\/(.*?)\?/', $youtube, $matches))
		{
			$youtube = (isset($matches[2]) ? $matches[2] : false);
		}
	}
	if($vimeo)
	{
		if(preg_match('/vimeo\.com\/video\/(.*?)\?/', $vimeo, $matches))
		{
			$vimeo = (isset($matches[1]) ? $matches[1] : false);
		}
	}
	?>

	<div class="row">
		<div class="col-9 col-lg-8">
			<?php
			if($subtitle)
			{
				?><h2 class="subtitle"><?php echo($subtitle); ?></h2><?php
			}
			?>
			<p class="description"><?php echo($content); ?></p>
		</div>

		<div class="col-3 col-lg-4">
			<?php
			if($youtube)
			{
				$src = "https://www.youtube-nocookie.com/embed/" . $youtube . "?rel=0";
				?><div class="shop-video"><iframe style="width: 100%; height: auto;" src="<?php echo($src); ?>" frameborder="0" allow="autoplay; encrypted-media" allowfullscreen></iframe></div><?php
			}
			if($vimeo)
			{
				$src = "https://player.vimeo.com/video/" . $vimeo . "?title=0&byline=0&portrait=0&badge=0";
				?><div class="shop-video"><iframe src="<?php echo($src); ?>" style="width: 100%; height: auto;" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></div><?php
			}
			?>

			<div id="shopCarousel" class="carousel slide" data-ride="carousel">
				<div class="carousel-inner">
					<?php
					$thumb = Mainframe::thumbnail(ABSOLUTE_PATH . $image, 1000, 750, "4:3", Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
					?><div class="carousel-item active"><img src="<?php echo($thumb); ?>" alt="<?php echo($alt); ?>" title="<?php echo($alt); ?>" class="d-block w-100" /></div><?php

					// Because of deletions, its possible to have gaps in the numbering.
					for($i=1; $i<=25; $i++)
					{
						// We already showed the main image.
						if($i == $main_image)
						{
							continue;
						}

						$img = $page->field("image" . $i, false);

						if($img)
						{
							$thumb2 = Mainframe::thumbnail(ABSOLUTE_PATH . $img, 1000, 750, "4:3", Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
							?><div class="carousel-item"><img src="<?php echo($thumb2); ?>" alt="<?php echo($alt); ?>" title="<?php echo($alt); ?>" class="d-block w-100" /></div><?php
						}
					}
					?>
				</div>

				<a class="carousel-control-prev" href="#shopCarousel" role="button" data-slide="prev">
					<span class="carousel-control-prev-icon" aria-hidden="true"></span>
					<span class="sr-only">Previous</span>
				</a>
				<a class="carousel-control-next" href="#shopCarousel" role="button" data-slide="next">
					<span class="carousel-control-next-icon" aria-hidden="true"></span>
					<span class="sr-only">Next</span>
				</a>
			</div>
		</div>

		<?php
		if(Mainframe::site()->shop)
		{
			$id = uniqid();
			?>
			<script>
				function getProductOptions()
				{
					<?php
					/*
					This would take the value of two sets of radio buttons and send them as product options.

					var options = [];
					options.push("Colour: " + jQuery("input[name='colour']:checked").val());
					options.push("Size: " + jQuery("input[name='size']:checked").val());

					return options;
					*/
					?>

					return null;
				}
			</script>

			<div class="col-12">
				<form method="post" onsubmit="shopAddToCart(<?php echo(Mainframe::page()->page_id); ?>, document.getElementById('<?php echo($id); ?>').value, getProductOptions(), event); return false;" class="form-row mb-2">
					<div class="col-3 col-md-2 col-lg-1">
						Price
					</div>
					<div class="col-9 col-md-10 col-lg-11">
						<?php echo((class_exists("Shop") ? Shop::currency()->currency_code : "CAD") . " $" . number_format($page->field("price"), 2)); ?>
					</div>
					<div class="col-3 col-md-2 col-lg-1">
						Quantity
					</div>
					<div class="col-3 col-md-2 col-lg-1">
						<input type="number" name="quantity" id="<?php echo($id); ?>" class="form-control" value="1" min="1" step="1" />
					</div>
					<div class="col-6 col-md-8 col-lg-10">
						<button type="submit" class="btn btn-primary">Add To Cart <em class="fas fa-shopping-cart"></em></button>
					</div>
				</form>
			</div>
			<?php
		}
		?>
	</div>
	<?php
}
else
{
	// List page, show preview.
	?>
	<p><img src="<?php echo($image); ?>" alt="<?php echo($alt); ?>" title="<?php echo($alt); ?>" /></p>
	<div>
		<?php echo($content); ?>
	</div>
	<?php
}
?>
