<form class="dialog document-edit nvfinder-document-dialog nvForm" id="nvfinder-document-dialog" onsubmit="nvfinder_document_save(); return false;">
	<?php csrf(); ?>
	<div class="text-right">
		<progress id="nvfinder_document_progress" class="d-none"></progress>
		<button type="submit" class="btn btn-primary"><em class="fas fa-fw fa-save" id="nvfinder_document_spinner" aria-hidden="true"></em> Save</button>
		<button type="button" class="btn btn-secondary" onclick="nvfinder_document_close()"><em class="fas fa-fw fa-times" aria-hidden="true"></em> Cancel</button>
	</div>

	<div class="row">
		<div class="<?php echo(TWO_COL); ?>">
			<fieldset class="accordion accordion-autofocus">
				<legend><em class="fas fa-fw fa-upload" aria-hidden="true"></em> File Information</legend>

				<div>
					<div class="alert alert-info">"Files" are actual files on your computer which you plan to upload.</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="upload_file" class="<?php echo(LABEL_COL); ?>">Upload New File</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "upload_file",
							              "id"          => "upload_file",
							              "type"       	=> "file",
							              "onchange" 	=> "getFileTitle(event)"
							            ));
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>">Overwrite File</label>
						<?php yesNo("overwrite", false); ?>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="filename" class="<?php echo(LABEL_COL); ?>">Choose Existing File</label>
						<div class="<?php echo(FIELD_COL); ?>"><select name="filename" id="filename" class="form-control custom-select"></select></div>
					</div>
				</div>
			</fieldset>

			<fieldset class="accordion">
				<legend><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> Document Information</legend>

				<div>
					<div class="alert alert-info">"Documents" are logical representations of files made available for downloading.</div>

					<input type="hidden" name="site_id" id="site_id" value="<?php echo(Mainframe::active_site_id()); ?>" />
					<input type="hidden" name="document_id" id="document_id" />

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="title" class="<?php echo(LABEL_COL); ?>">Title</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "title",
							              "id"          => "title",
							              "required"	=> "required",
										  "onblur"		=> "updateURL(this, 'url', null, false);document.getElementById('url').onkeyup();",
							              "class" 		=> "form-control"
							            ));
							?><em class="help">Short and meaningful</em>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="url" class="<?php echo(LABEL_COL); ?>">URL</label>
						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							echo form_input(array(
							              "name"        => "url",
							              "id"          => "url",
							              "required"	=> "required",
							              "onkeyup" 	=> "jQuery('#url_preview').html(this.value)",
							              "class" 		=> "form-control"
							            ));
							?>
						</div>
					</div>
					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>">&nbsp</label>
						<div class="<?php echo(FIELD_COL); ?>"><div class="alert alert-info"><?php echo(LIVE_SITE); ?>/document/<span id="url_preview"></span></div></div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label for="category_id" class="<?php echo(LABEL_COL); ?>">Category</label>

						<div class="<?php echo(FIELD_COL); ?>">
							<?php
							$wgt = new FeralBasicSelectWidget("category_id", "", "form-control custom-select");
							$wgt->AddOption(0, "None");

							foreach($categories as $category)
							{
								$wgt->AddOption($category->category_id, $category->name);
							}
							$wgt->Create();
							?>
						</div>
					</div>

					<div class="<?php echo(FORM_ROW); ?>">
						<label class="<?php echo(LABEL_COL); ?>">Published</label>
						<?php yesNo("published", true); ?>
					</div>
				</div>
			</fieldset>
		</div>

		<div class="<?php echo(TWO_COL); ?>">
			<?php $this->load->view("admin/acl", array("acls" => (isset($acls) ? $acls : array()))); ?>
		</div>

		<div class="col-12">
			<fieldset>
				<legend>Description</legend>

				<?php
				echo form_textarea(array(
				              "name"  => "description",
				              "id"    => "description",
							  "class" => "form-control"
				            ));
				?>
			</fieldset>
		</div>
	</div>
	<script>
		var nvFinderPath = "<?php echo(LIVE_SITE); ?>/finder";
		var editor = null;

		var initWYSIWYG = function()
		{
			editor = CKEDITOR.replace( 'description',
			{
				filebrowserBrowseUrl : nvFinderPath,
				filebrowserNvimageBrowseUrl : nvFinderPath + '?type=images',
				filebrowserNvdocumentBrowseUrl : nvFinderPath + '?type=documents',
				filebrowserUploadUrl : nvFinderPath + '/quick_upload?type=files',
				filebrowserNvimageUploadUrl : nvFinderPath + '/quick_upload?type=images',
				filebrowserNvdocumentUploadUrl : nvFinderPath + '/quick_upload?type=documents',
				height: '200px',
				toolbar: [
					{ name: 'document', items: [ 'Source', '-', 'RemoveFormat', '-', 'ShowBlocks' ] },
					{ name: 'insert', items: [ 'Image', 'Table', 'HorizontalRule' ] },
					{ name: 'links', items: [ 'Link', 'Unlink', 'Anchor' ] },
					{ name: 'clipboard', items: [ 'PasteText', 'PasteFromWord', '-', 'Scayt' ] },
					{ name: 'basicstyles', items: [ 'Bold', 'Italic', 'Underline' ] },
					{ name: 'paragraph', items: [ 'NumberedList', 'BulletedList', '-', 'Blockquote', '-', 'JustifyLeft', 'JustifyCenter', 'JustifyRight', 'JustifyBlock' ] },
					{ name: 'styles', items: [ 'Styles', 'Format', 'FontSize' ] },
					{ name: 'colors', items: [ 'TextColor', 'BGColor' ] }
				]
			});
		};
	</script>
</form>
