<div id="nvfinder-menu" class="nvfinder-menu"></div>
<h2 class="nvfinder-title">Media Manager</h2>

<div class="row">
	<div class="col-3">
		<div class="nvfinder-fixed">
			<fieldset>
				<legend>Current Directory Actions</legend>

				<div>
					<form class="nvForm" onsubmit="nvfinder_show_files(); return false;">
						<div class="row">
							<div class="col-10"><input type="search" id="nvfinder-search" class="form-control" /></div>
							<div class="col-2"><button type="submit" class="btn btn-small btn-primary" onclick="nvfinder_show_files()"><em class="fas fa-search" aria-hidden="true"></em></button></div>
						</div>
					</form>
				</div>
				<div class="action-panel"><button
					type="button" class="btn btn-info" id="nvfinder-upload-button" onclick="nvfinder_upload_dialog()" title="Upload Files"><em class="fas fa-fw fa-cloud-upload-alt" aria-hidden="true"></em> Upload Files</button><button
					type="button" class="btn btn-info d-none" id="nvfinder-document-button" onclick="nvfinder_edit_document(false)" title="Create a New Document"><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> New Document</button><button
					type="button" class="btn btn-info" id="nvfinder-mkdir-button" onclick="nvfinder_newdir()" title="Create a New Directory"><em class="fas fa-fw fa-plus-circle" aria-hidden="true"></em> New Directory</button><button
					type="button" class="btn btn-info" id="nvfinder-rename-button" onclick="nvfinder_rename_directory()" title="Rename the Current Directory"><em class="fas fa-fw fa-pencil-alt" aria-hidden="true"></em> Rename Directory</button><button
					type="button" class="btn btn-info" id="nvfinder-rmdir-button" onclick="nvfinder_delete_directory()" title="Delete the Current Directory"><em class="fas fa-fw fa-times-circle" aria-hidden="true"></em> Delete Directory</button><button
					type="button" class="btn btn-info" id="nvfinder-download-directory-button" onclick="nvfinder_download_directory(event)" title="Download a ZIP Archive of the Current Directory"><em class="fas fa-fw fa-file-archive" aria-hidden="true"></em> Download All Files</button>
				</div>
			</fieldset>

			<div class="nvfinder-column nvfinder-column1">
				<fieldset class="nvfinder-directories">
					<legend>Directories</legend>

					<ul class="fa-ul" id="nvfinder-directory-list"></ul>
				</fieldset>
			</div>
		</div>
	</div>

	<div class="col-9">
		<fieldset class="nvfinder-column nvfinder-column2 nvfinder-files">
			<legend><span class="nvfinder-files-title">Files</span> <em class="fas fa-fw fa-spinner d-none" id="nvfinder_loading_spinner" aria-hidden="true"></em></legend>

			<p id="nvfinder-directory-info" class="alert alert-info d-none"></p>
			<div id="nvfinder-files"></div>
		</fieldset>
	</div>
</div>

<script>
jQuery(window).on("load", function()
{
	<?php
	if($type == "documents")
	{
		?>nvfinder_cwd = "documents";<?php
	}
	else
	{
		?>nvfinder_cwd = "images";<?php
	}
	?>
	nvfinder_setFileType('<?php echo($type); ?>');
	nvfinder_setFunctionNumber('<?php echo($CKEditorFuncNum); ?>');
	nvfinder_reload_directories();
	nvfinder_filter(nvfinder_cwd, null);

	jQuery('#image-cropper').cropit(
    {
    	width: 640,
    	height: 480,
    	allowDragNDrop: false,
    	freeMove: false,
    	smallImage: 'allow',
    	initialZoom: 'min',
    	minZoom: 'fit',
    	maxZoom: 5,
    	exportZoom: 2,
    	imageBackground: true
    });

	// Handle rotation
	jQuery('.rotate-cw-btn').off("click").on("click", function()
	{
	  	jQuery('#image-cropper').cropit('rotateCW');
	});
	jQuery('.rotate-ccw-btn').off("click").on("click", function()
	{
	  	jQuery('#image-cropper').cropit('rotateCCW');
	});
});
</script>
