<h2>Preconfigured Pages</h2>
<p>Use this page to automatically create the required modules, pages, and menu links for the type of page selected.</p>

<div class="row">
	<div class="col-12 col-md-6">
		<div class="list-group">
			<a href="/install/search" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-search" aria-hidden="true"></em> Search Results Page</a>
			<a href="/install/contact" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-phone" aria-hidden="true"></em> Contact Page</a>
			<a href="/install/gallery" class="list-group-item list-group-item-action"><em class="far fa-fw fa-file-image" aria-hidden="true"></em> Gallery Page</a>
			<a href="/install/directory" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-building" aria-hidden="true"></em> Business Directory</a>
			<a href="/install/shop" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-shopping-cart" aria-hidden="true"></em> Shop Section</a>
			<a href="/install/documents" class="list-group-item list-group-item-action"><em class="far fa-fw fa-file-pdf" aria-hidden="true"></em> Documents Page</a>
			<a href="/install/login_registration" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-user-plus" aria-hidden="true"></em> User Login / Registration Page</a>
			<a href="/install/login" class="list-group-item list-group-item-action"><em class="far fa-fw fa-user" aria-hidden="true"></em> User Login Page</a>
			<a href="/install/registration" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-users" aria-hidden="true"></em> User Registration Page</a>
			<a href="/install/portfolio" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-briefcase" aria-hidden="true"></em> Portfolio Page</a>
			<a href="/install/testimonials" class="list-group-item list-group-item-action"><em class="fas fa-fw fa-thumbs-up" aria-hidden="true"></em> Testimonials Page</a>
		</div>
	</div>
	<div class="col-12 col-md-6">
		<fieldset>
			<legend>Create a Content List Page (a.k.a. "blog" or "news")</legend>

			<form method="post" action="/install/content" class="nvForm">
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="title" class="col-12 col-md-4 col-lg-3">Page Title</label>
					<div class="col-12 col-md-8 col-lg-9"><input type="text" name="title" id="title" class="form-control" data-nvform-validation-position="bottom" required /></div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="link_checkbox" class="col-12 col-md-4 col-lg-3">Create a Menu Link</label>
					<div class="col-12 col-md-8 col-lg-9"><?php yesNo("link", 0); ?></div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="link_text" class="col-12 col-md-4 col-lg-3">Menu Link Text</label>
					<div class="col-12 col-md-8 col-lg-9"><input type="text" name="link_text" id="link_text" class="form-control" /></div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="category_id" class="col-12 col-md-4 col-lg-3">Content From Existing Category</label>

					<div class="col-12 col-md-8 col-lg-9">
						<?php
						$wgt = new FeralBasicSelectWidget("category_id", "", "form-control custom-select");
						$wgt->AddOption(0, "Any Category");

						foreach($categories as $category)
						{
							$wgt->AddOption($category->category_id, $category->name);
						}
						$wgt->Create();
						?>
					</div>
				</div>
				<div class="<?php echo(FORM_ROW); ?>">
					<label for="category" class="col-12 col-md-4 col-lg-3">Or Create a New Category</label>
					<div class="col-12 col-md-8 col-lg-9"><input type="text" name="category" id="category" class="form-control" /></div>
				</div>

				<div class="text-center">
					<button type="submit" class="btn btn-primary"><em class="fas fa-fw fa-list" aria-hidden="true"></em> Create Content List Page</button>
				</div>
			</form>
		</fieldset>
	</div>
</div>