<div id="module_<?php echo($module_instance_id); ?>" class="module content-list-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}

	if($q)
	{
		if($title_heading_level)
		{
			$heading = substr($title_heading_level, 1) + 1;
		}
		else
		{
			$heading = 2;
		}
		?>
		<div class="row">
			<div class="col-12 col-sm-8">
				<p class="search-summary">Your search for "<?php echo($q); ?>" returned <?php echo(number_format($total, 0)); ?> results.</p>
			</div>
			<div class="col-12 col-sm-4 text-right">
				<form action="" method="get" class="form-row">
					<div class="col-10"><input type="search" placeholder="<?php echo($search_legend); ?>" aria-label="<?php echo($search_legend); ?>" name="q<?php echo($module_instance_id); ?>" value="<?php echo(html_escape($this->input->get_post("q" . $module_instance_id))); ?>" class="form-control" /></div>
					<div class="col-2"><button type="submit" class="btn btn-primary" title="<?php echo($search_legend); ?>"><em class="fas fa-fw fa-search" aria-hidden="true"></em><span class="d-none"><?php echo($search_legend); ?></span></button></div>
				</form>
			</div>
		</div>
		<?php

		if($total > 0)
		{
			?><h<?php echo($heading); ?>>Search Results</h<?php echo($heading); ?>><?php
		}
	}
	$count = 0;

	if($layout == "year")
	{
		?>
		<div class="row">
			<?php
			$cat_cols 	= array();
			$count 		= count($categories);
			$split 		= floor($count/5);
			$offset 	= 0;
			$mod 		= $count % 5;

			for($i=0; $i<5; $i++)
			{
				// If there's an odd number of documents, toss the extras in column 1.
				$cat_cols[$i] = array_slice($categories, $offset, ($mod ? $split+1 : $split));
				$offset += ($mod ? $split+1 : $split);
			}

			foreach($cat_cols as $col)
			{
				?><div class="col-12 col-sm-6 col-md-3 col-lg-2"><?php

				foreach($col as $cat)
				{
					$link = "/" . Mainframe::page()->url . "?year=" . $cat->year;
					$icon = ($cat->year == $year ? "fa-folder-open" : "fa-folder");
					?>
					<div><a href="<?php echo($link); ?>"><?php echo('<em class="far fa-fw ' . $icon . '" aria-hidden="true"></em> '); ?><?php echo($cat->name); ?> (<?php echo($cat->total); ?>)</a></div>
					<?php
				}
				?></div><?php
			}
			?>
		</div>
		<?php
		if($title_heading_level)
		{
			$heading = substr($title_heading_level, 1) + 1;
		}
		else
		{
			$heading = 2;
		}
		?><h<?php echo($heading); ?>><?php echo($year); ?></h<?php echo($heading); ?>><?php
	}
	?>
	<div class="row">
		<?php
		foreach($pages as $p)
		{
			$count++;
			$article 	= Mainframe::preview($p, false, false);
			$link 		= ($p->url_override ? $p->url_override : "/" . $p->url);
			$featured 	= ($count <= $num_featured);

			if($featured)
			{
				$cols = $num_columns_featured;
			}
			else
			{
				$cols = $num_columns;
			}

			if($cols == 1)
			{
				$class = "col-12";
			}
			else if($cols == 2)
			{
				$class = TWO_COL;
			}
			else if($cols == 3)
			{
				$class = THREE_COL;
			}
			else if($cols == 4)
			{
				$class = TWO_COL . " col-lg-3";
			}
			else 	// failsafe
			{
				$class = "col-12";
			}
			?>
			<div class="<?php echo($class); ?>">
				<article class="<?php echo(($featured ? "featured-article" : "article")); ?>">
					<?php
					if($show_title == "above")
					{
						?><<?php echo($heading_level); ?>><?php
						if(!$do_not_link)
						{
							?><a href="<?php echo($link); ?>"><?php
						}
						?><?php echo($p->title); ?><?php
						if(!$do_not_link)
						{
							?></a><?php
						}
						?>
						</<?php echo($heading_level); ?>><?php
					}

					if($featured)
					{
						$show_image 	= $show_image_featured;
						$width 			= $image_width_featured;
						$height 		= $image_height_featured;
						$raw 			= $image_raw_featured;
						$crop 			= $image_crop_featured;
					}
					else
					{
						$show_image 	= $show_image;
						$width 			= $image_width;
						$height 		= $image_height;
						$raw 			= $image_raw;
						$crop 			= $image_crop;
					}

					if($crop === null)
					{
						$crop = "0";
					}
					else
					{
						$crop = $width.":".$height.":".$crop;
					}

					if($show_image)
					{
						// Remove all module placeholder images first.
						$article = preg_replace('/<img(.*?)class="module_placeholder"(.*?)\/?>/', "", $article);
						// Remove all but the first image and place it at the top of the article
						// Set first image to something special
						$article = preg_replace('/<img (.*?)\/?>/', "<imgx $1 />", $article, 1);
						// Remove all images
						$article = preg_replace('/<img (.*?)\/?>/', "", $article);
						// Set our special (first) image back to a proper tag
						$article = preg_replace('/<imgx (.*?)\/?>/', "<img $1 />", $article, 1);
						// Grab our image
						preg_match('/(<img (.*?)\/?>)/', $article, $images);

						if(count($images) > 0)
						{
							//extract the image src and create a div with a slice of the image, rather than full size
							preg_match('/<img .*?src=[\'"](.*?)[\'"].*?>/', $images[0], $srcs);

							set_time_limit(60);
							// Check if this is a resized image and use the full size image to create a more suitable image size.
							if(preg_match('/_([0-9]*)x([0-9]*)\.(jpe?g|png|gif|webp)/i', $srcs[1]))
							{
								$src 			= preg_replace('/^\/images\/thumbnails\//', '/images/', str_replace(LIVE_SITE, "", preg_replace('/_([0-9]*)x([0-9]*)\.(jpe?g|png|gif|webp)/i', '.$3', $srcs[1])));
								$original_src 	= $srcs[1];
							}
							else
							{
								$src 			= $srcs[1];
								$original_src 	= $src;
							}
							$src = "/img/" . $width . "/" . $height . "/" . $crop . "?src=" . urlencode($src);

							$new_div = "";

							if(!$do_not_link)
							{
								$new_div .= '<a href="' . $link . '">';
							}
							if($raw)
							{
								$srcs[0] = preg_replace(array('/width: [0-9]*px;/',
								                              '/height: [0-9]*px;/'),
														array('width: ' . $width . 'px;',
														      'height: ' . $height . 'px;'),
														$srcs[0]);
								$new_div .= str_replace($original_src, $src, $srcs[0]);
							}
							else
							{
								$new_div .= '<img src="' . $src . '" alt="' . str_replace('"', '', $p->title) . '" title="' . str_replace('"', '', $p->title) . '" class="lazy" onload="this.style.opacity=1" style="width: ' . $width . 'px; height: auto;" />';
							}
							if(!$do_not_link)
							{
								$new_div .= '</a>';
							}

							//remove the image from our content
							$article = preg_replace('/<img (.*?)\/?>/', "", $article);

							if($show_text)
							{
								$article = $new_div . $article;
							}
							else
							{
								$article = $new_div;
							}

							if($show_date)
							{
								$article = str_replace($new_div, $new_div . '<time datetime="' . date("Y-m-d H:i:s", strtotime($p->created)) . '">' . date("l, F jS, Y", strtotime($p->created)) . '</time>', $article);
							}

							if($show_title == "below")
							{
								$article = str_replace($new_div, $new_div . '<' . $heading_level . '>' . (!$do_not_link ? '<a href="' . $link . '">' : '') . $p->title . (!$do_not_link ? '</a>' : '') . '</' . $heading_level . '>', $article);
							}
						}
					}

					if(!$show_image || ($show_image && count($images) == 0))
					{
						$article = ($show_text ? $article : "");

						if($show_date)
						{
							$article = '<time datetime="' . date("Y-m-d H:i:s", strtotime($p->created)) . '">' . date("l, F jS, Y", strtotime($p->created)) . '</time>' . $article;
						}
						if($show_title == "below")
						{
							$article = '<' . $heading_level . '>' . (!$do_not_link ? '<a href="' . $link . '">' : '') . $p->title . (!$do_not_link ? '</a>' : '') . '</' . $heading_level . '>' . $article;
						}
					}

					if($strip_tags == "some")
					{
						$article = strip_tags($article, "<p><div><a><img><br><em><i><time><" . $heading_level . ">");
					}
					else if($strip_tags == "all")
					{
						$article = strip_tags($article, "<p><div><a><br><em><i><time><" . $heading_level . ">");
					}
					else
					{
						// Always remove audio and video.
						$article = preg_replace("/<audio.*?<\/audio>/", "", $article);
						$article = preg_replace("/<video.*?<\/video>/", "", $article);
					}

					$truncated = false;

					if($show_text)
					{
						//Remove empty paragraphs (whitespace, non-breaking space HTML, and non-breaking space Unicode)
						$article = preg_replace('/(<p>(\s|&nbsp;|\x{00A0})*<\/p>)/', '', $article);
						$strlen1 = strlen($article);

						if($strlen1 > $character_limit && $character_limit > 0)
						{
							$article = truncate($article, $character_limit, array('ending' => "...", 'exact' => false, 'html' => true));
							$strlen2 = strlen($article);
							$truncated = ($strlen1 != $strlen2);
						}
					}

					if(!$never_show_readmore && ((!$do_not_link && $truncated) || $always_show_readmore))
					{
						$article .= "<p><a href=\"$link\" class=\"btn btn-primary btn-readmore\">" . $read_more_text . "</a></p>";
					}

					echo($article);
					?>
				</article>
			</div>
			<?php
		}
		?>
	</div>
	<?php
	if($next || $prev)
	{
		?>
		<div class="content-list-pagination">
			<?php
			if($prev)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $prev : "?p=" . $prev) . ($year ? "&year=" . $year : "");;
				?><a href="<?php echo($link); ?>" class="btn btn-primary" title="Previous <?php echo($per_page); ?> Results"><em class="fas fa-fw fa-chevron-left" aria-hidden="true"></em> Prev <?php echo($per_page); ?></a><?php
			}
			?> <a href="#" onclick="return false" class="btn btn-primary" title="Page <?php echo($page_number); ?> of <?php echo($page_count); ?>">Page <?php echo($page_number); ?> of <?php echo($page_count); ?></a> <?php
			if($next)
			{
				$link = "/" . Mainframe::page()->url . ($q ? "?q=" . $q . "&p=" . $next : "?p=" . $next) . ($year ? "&year=" . $year : "");;
				?><a href="<?php echo($link); ?>" class="btn btn-primary" title="Next <?php echo($per_page); ?> Results">Next <?php echo($per_page); ?> <em class="fas fa-fw fa-chevron-right" aria-hidden="true"></em></a><?php
			}
			?>
		</div>
		<?php
	}
	?>
</div>
