<div id="module_<?php echo($module_instance_id); ?>" class="module content-slider-module <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>
	<ul id="slider_<?php echo($module_instance_id); ?>">
		<?php
		foreach($pages as $p)
		{
			$article 	= Mainframe::preview($p, false, false);
			$link 		= "/" . $p->url;
			?>
			<li>
				<article>
					<?php
					$first_heading = false;

					if($show_title)
					{
						?><<?php echo($heading_level); ?>><a href="<?php echo($link); ?>"><?php echo($p->title); ?></a></<?php echo($heading_level); ?>><?php
					}
					else
					{
						if($link_first_heading)
						{
							preg_match('/<h([1-5]?)>/', $article, $headings);
							$first_heading = (isset($headings[1][0]) ? $headings[1][0] : false);

							if($first_heading)
							{
								$article = preg_replace('/<h' . $first_heading . '>/', '<' . $heading_level . '><a href="' . $link . '">', $article, 1);
								$article = preg_replace('/<\/h' . $first_heading . '>/', '</a></' . $heading_level . '>', $article, 1);
							}
						}
			            else
			            {
							preg_match('/<h([1-5]?)>/', $article, $headings);
							$first_heading = (isset($headings[0][1]) ? $headings[1][0] : false);

							if($first_heading)
							{
								$article = preg_replace('/<h' . $first_heading . '>/', '<' . $heading_level . '>', $article, 1);
								$article = preg_replace('/<\/h' . $first_heading . '>/', '</' . $heading_level . '>', $article, 1);
							}
						}
					}

					// Remove all module placeholder images first.
					$article = preg_replace('/<img(.*?)class="module_placeholder"(.*?)\/?>/', "", $article);
					// Remove all but the first image and place it at the top of the article
					// Set first image to something special
					$article = preg_replace('/<img (.*?)\/?>/', "<imgx $1 />", $article, 1);
					// Remove all images
					$article = preg_replace('/<img (.*?)\/?>/', "", $article);
					// Set our special (first) image back to a proper tag
					$article = preg_replace('/<imgx (.*?)\/?>/', ($link_first_image ? '<a href="' . $link . '">' : '') . "<img $1 style='width: " . $image_width . "px;height:" . $image_height . "px;' />" . ($link_first_image ? '</a>': ''), $article, 1);
					// Grab our image
					preg_match('/(<img (.*?)\/?>)/', $article, $images);

					if(count($images) > 0 && $image_alignment != "none")
					{
						//extract the image src and create a div with a slice of the image, rather than full size
						preg_match('/<img .*?src=[\'"](.*?)[\'"].*?>/', $images[0], $srcs);

						// Check if this is a resized image and use the full size image to create a more suitable image size.
						if(preg_match('/_([0-9]*)x([0-9]*)\.(jpe?g|png|gif|webp)/i', $srcs[1]))
						{
							$src = preg_replace('/^\/images\/thumbnails\//', '/images/', str_replace(LIVE_SITE, "", preg_replace('/_([0-9]*)x([0-9]*)\.(jpe?g|png|gif|webp)/i', '.$3', $srcs[1])));
						}
						else
						{
							$src = str_replace(LIVE_SITE, "", $srcs[1]);
						}

						$src = "/img/" . $image_width . "/" . $image_height . "/" . $image_width . ":" . $image_height . "?src=" . urlencode($src); // Mainframe::thumbnail(ABSOLUTE_PATH . $src, $image_width, $image_height, $image_width . ":" . $image_height, Mainframe::site()->webp ? IMAGETYPE_WEBP : null);
						$new_div = "";

						if($link_first_image)
						{
							$new_div .= '<a href="' . $link . '">';
						}
						$new_div .= '<img src="' . $src . '" style="width: ' . $image_width . 'px; height: ' . $image_height . 'px;" class="lazy ' . ($image_alignment != 'none' ? 'image-' . $image_alignment : '') . '" onload="this.style.opacity=1" />';

						if($link_first_image)
						{
							$new_div .= '</a>';
						}

						//remove the image from our content
						$article = preg_replace('/<img (.*?)\/?>/', "", $article);

						if($first_heading)
						{
							// Place the new image div after the first heading, because we already found one.
							$article = preg_replace("/<\/h([1-5])>/", "</h$1>" . $new_div, $article, 1);
						}
						else
						{
							// If we don't have a heading, put the new image div at the top of the article.
							$article = $new_div . $article;
						}

						// If we don't want text shown, truncate after $new_div
						if(!$show_text)
						{
							$index 		= strpos($article, $new_div) + strlen($new_div);
							$article 	= substr($article, 0, $index);
						}

						if($show_date)
						{
							$article = str_replace($new_div, $new_div . '<time datetime="' . date("Y-m-d H:i:s", strtotime($p->created)) . '">' . date("l, F jS, Y", strtotime($p->created)) . '</time>', $article);
						}

						if($show_title == "below")
						{
							$article = str_replace($new_div, $new_div . '<' . $heading_level . '><a href="' . $link . '">' . $p->title . '</a></' . $heading_level . '>', $article);
						}
					}
					else
					{
						$article = ($show_text ? $article : "");

						if($show_date)
						{
							$article = '<time datetime="' . date("Y-m-d H:i:s", strtotime($p->created)) . '">' . date("l, F jS, Y", strtotime($p->created)) . '</time>' . $article;
						}
						if($show_title == "below")
						{
							$article = '<' . $heading_level . '><a href="' . $link . '">' . $p->title . '</a></' . $heading_level . '>' . $article;
						}
					}

					if($strip_tags == "some")
					{
						$article = strip_tags($article, "<p><div><a><img><br><time><" . $heading_level . ">");
					}
					else if($strip_tags == "all")
					{
						$article = strip_tags($article, "<p><div><a><br><time><" . $heading_level . ">");
					}
					else
					{
						// Always remove audio and video.
						$article = preg_replace("/<audio.*?<\/audio>/", "", $article);
						$article = preg_replace("/<video.*?<\/video>/", "", $article);
					}

					$truncated = false;

					if($show_text)
					{
						//Remove empty paragraphs (whitespace, non-breaking space HTML, and non-breaking space Unicode)
						$article = preg_replace('/(<p>(\s|&nbsp;|\x{00A0})*<\/p>)/', '', $article);

						if(strlen($article) > $character_limit && $character_limit > 0)
						{
							$truncated = true;
							$article = truncate($article, $character_limit, array('ending' => "...", 'exact' => false, 'html' => true));
						}
					}

					if($always_show_readmore || $truncated)
					{
						$article .= "<p><a href=\"$link\" class=\"btn btn-primary btn-readmore\">" . $read_more_text . "</a></p>";
					}

					echo($article);
					?>
				</article>
			</li>
			<?php
		}
		?>
	</ul>

	<script>
    	jQuery(window).on("load", function(){
		    jQuery('#slider_<?php echo($module_instance_id); ?>').bxSlider({
				mode: "<?php echo($config_mode); ?>",
				speed: <?php echo($config_speed); ?>,
				slideMargin: <?php echo($config_slideMargin); ?>,
				startSlide: <?php echo($config_startSlide); ?>,
				randomStart: <?php echo(($config_randomStart == 1 ? "true" : "false")); ?>,
				slideSelector: "<?php echo($config_slideSelector); ?>",
				infiniteLoop: <?php echo(($config_infiniteLoop == 1 ? "true" : "false")); ?>,
				hideControlOnEnd: <?php echo(($config_hideControlOnEnd == 1 ? "true" : "false")); ?>,
				easing: "<?php echo($config_easing); ?>",
				captions: <?php echo(($config_captions == 1 ? "true" : "false")); ?>,
				ticker: <?php echo(($config_ticker == 1 ? "true" : "false")); ?>,
				tickerHover: <?php echo(($config_tickerHover == 1 ? "true" : "false")); ?>,
				adaptiveHeight: <?php echo(($config_adaptiveHeight == 1 ? "true" : "false")); ?>,
				adaptiveHeightSpeed: <?php echo($config_adaptiveHeightSpeed); ?>,
				video: <?php echo(($config_video == 1 ? "true" : "false")); ?>,
				responsive: <?php echo(($config_responsive == 1 ? "true" : "false")); ?>,
				useCSS: <?php echo(($config_useCSS == 1 ? "true" : "false")); ?>,
				preloadImages: "<?php echo($config_preloadImages); ?>",
				touchEnabled: <?php echo(($config_touchEnabled == 1 ? "true" : "false")); ?>,
				swipeThreshold: <?php echo($config_swipeThreshold); ?>,
				oneToOneTouch: <?php echo(($config_oneToOneTouch == 1 ? "true" : "false")); ?>,
				preventDefaultSwipeX: <?php echo(($config_preventDefaultSwipeX == 1 ? "true" : "false")); ?>,
				preventDefaultSwipeY: <?php echo(($config_preventDefaultSwipeY == 1 ? "true" : "false")); ?>,
				pager: <?php echo(($config_pager == 1 ? "true" : "false")); ?>,
				pagerType: "<?php echo($config_pagerType); ?>",
				pagerShortSeparator: "<?php echo($config_pagerShortSeparator); ?>",
				pagerSelector: "<?php echo($config_pagerSelector); ?>",
				pagerCustom: "<?php echo($config_pagerCustom); ?>",
				buildPager: "<?php echo($config_buildPager); ?>",
				controls: <?php echo(($config_controls == 1 ? "true" : "false")); ?>,
				nextText: "<?php echo($config_nextText); ?>",
				prevText: "<?php echo($config_prevText); ?>",
				nextSelector: "<?php echo($config_nextSelector); ?>",
				prevSelector: "<?php echo($config_prevSelector); ?>",
				autoControls: <?php echo(($config_autoControls == 1 ? "true" : "false")); ?>,
				startText: "<?php echo($config_startText); ?>",
				stopText: "<?php echo($config_stopText); ?>",
				autoControlsCombine: <?php echo(($config_autoControlsCombine == 1 ? "true" : "false")); ?>,
				autoControlsSelector: "<?php echo($config_autoControlsSelector); ?>",
				auto: <?php echo(($config_auto == 1 ? "true" : "false")); ?>,
				pause: <?php echo($config_pause); ?>,
				autoStart: <?php echo(($config_autoStart == 1 ? "true" : "false")); ?>,
				autoDirection: "<?php echo($config_autoDirection); ?>",
				autoHover: <?php echo(($config_autoHover == 1 ? "true" : "false")); ?>,
				autoDelay: <?php echo($config_autoDelay); ?>,
				minSlides: <?php echo($config_minSlides); ?>,
				maxSlides: <?php echo($config_maxSlides); ?>,
				moveSlides: <?php echo($config_moveSlides); ?>,
				slideWidth: <?php echo($config_slideWidth); ?>
			});
		});
    </script>
</div>
