<?php
if(!function_exists("docsort"))
{
	function docsort($a, $b)
	{
		if($a->category_name > $b->category_name)
		{
			return 1;
		}
		else if($a->category_name < $b->category_name)
		{
			return -1;
		}
		else
		{
			if($a->title > $b->title)
			{
				return 1;
			}
			else if($a->title < $b->title)
			{
				return -1;
			}
			else
			{
				return 0;
			}
		}
	}
}
?>
<div id="module_<?php echo($module_instance_id); ?>" class="module content-list-module content-list-alphabetical <?php echo($module_class); ?>">
	<?php
	if($title && $title_heading_level)
	{
		?><<?php echo($title_heading_level); ?> class="module-title"><?php echo($title); ?></<?php echo($title_heading_level); ?>><?php
	}
	?>
	<div class="row">
		<?php
		$last_category_id = 0;
		$open = false;

		if($num_columns == 1)
		{
			$class = "col-12";
		}
		else if($num_columns == 2)
		{
			$class = TWO_COL;
		}
		else if($num_columns == 3)
		{
			$class = THREE_COL;
		}
		else if($num_columns == 4)
		{
			$class = TWO_COL . " col-lg-3";
		}
		else 	// failsafe
		{
			$class = "col-12";
		}

		usort($documents, "docsort");

		foreach($documents as $d)
		{
			$category = ($d->category_id ? $d->category_name : "Uncategorized");

			if($last_category_id !== $d->category_id)
			{
				if($open)
				{
					?></ul></fieldset></div><?php
				}
				$open = true;
				?><div class="<?php echo($class); ?>"><fieldset><legend><?php echo($category); ?></legend><ul><?php
			}
			$link = LIVE_SITE . "/document/" . $d->url;
			?><li><a href="<?php echo($link); ?>"><?php echo($d->title); ?></a></li><?php
			$last_category_id = $d->category_id;
		}

		if($open)
		{
			?></ul></fieldset></div><?php
		}
		?>
	</div>
</div>